/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.fileupload;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.upload.TurbineUpload;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.upload.FileItem;
import org.apache.velocity.context.Context;

public class FileuploadFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileuploadFormData.class.getName());
    public static final String ATTACHMENT_INIT = "attachmentinit";
    public static final String KEY_ATTACHMENT_ID = "attachment";
    private final int FIELD_ATTACHMENT_MAX_LEN = 128;
    private String folderName = null;
    private FileuploadBean filebean = null;
    private FileItem attachmentItem = null;
    private ALStringField attachmentName = null;
    private int nowSize = 0;
    private int maxSize = 0;
    private int userId = -1;
    private String org_id = null;
    File rootFolder = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.userId = ALEipUtils.getUserId((RunData)rundata);
        this.org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        this.rootFolder = FileuploadUtils.getRootFolder(this.org_id, this.userId);
        this.folderName = rundata.getParameters().getString("folderName");
        if (this.folderName == null || "".equals(this.folderName)) {
            this.folderName = this.getNewAttachmentFolderName(this.rootFolder);
        }
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        ParameterParser parser = rundata.getParameters();
        this.attachmentItem = parser.getFileItem(KEY_ATTACHMENT_ID);
        if (this.attachmentItem != null) {
            File file = new File(this.attachmentItem.getName());
            this.attachmentName.setValue(file.getName());
        }
        this.nowSize = parser.getInt("nsize", 0);
        this.maxSize = parser.getInt("msize", 0);
        return true;
    }

    protected void setValidator() {
        this.attachmentName.setNotNull(true);
        this.attachmentName.limitMaxLength(128);
        this.attachmentName.setCharacterType(0);
    }

    protected boolean validate(ArrayList msgList) {
        if (this.attachmentItem != null) {
            if (this.attachmentItem.getSize() > 0L) {
                String folderpath = this.rootFolder + File.separator + this.folderName;
                long fileSizeSum = FileuploadUtils.getFolderSize(folderpath);
                if ((fileSizeSum += this.attachmentItem.getSize()) > (long)TurbineUpload.getSizeMax()) {
                    msgList.add("\u8ffd\u52a0\u3057\u305f\u30d5\u30a1\u30a4\u30eb\u306e\u5168\u5bb9\u91cf\u304c 7MB \u3088\u308a\u3082\u5927\u304d\u304f\u306a\u308a\u307e\u3057\u305f\u3002\u3053\u308c\u4ee5\u4e0a\u3001\u30d5\u30a1\u30a4\u30eb\u3092\u8ffd\u52a0\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                } else {
                    this.attachmentName.validate(msgList);
                }
            } else {
                msgList.add("\u30b5\u30a4\u30ba\u304c 0KB \u306e\u30d5\u30a1\u30a4\u30eb\u3092\u8ffd\u52a0\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
            }
        } else {
            msgList.add("\u8ffd\u52a0\u3057\u305f\u30d5\u30a1\u30a4\u30eb\u306e\u5168\u5bb9\u91cf\u304c 7MB \u3088\u308a\u3082\u5927\u304d\u304f\u306a\u308a\u307e\u3057\u305f\u3002\u3053\u308c\u4ee5\u4e0a\u3001\u30d5\u30a1\u30a4\u30eb\u3092\u8ffd\u52a0\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (this.maxSize > 0 && this.nowSize >= this.maxSize) {
            msgList.add("\u3053\u308c\u4ee5\u4e0a\u3001\u30d5\u30a1\u30a4\u30eb\u3092\u8ffd\u52a0\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            File saveFolder = new File(this.rootFolder + File.separator + this.folderName);
            if (!saveFolder.exists()) {
                saveFolder.mkdirs();
            }
            String newAttachmentFileName = this.getNewAttachmentFileName(saveFolder);
            int fileId = Integer.parseInt(newAttachmentFileName);
            String realfilename = FileuploadUtils.getRealFileName(this.attachmentItem.getName());
            String filepath = this.rootFolder + File.separator + this.folderName + File.separator + newAttachmentFileName;
            File file = new File(filepath);
            file.createNewFile();
            this.attachmentItem.write(file.getAbsolutePath());
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filepath + ".txt"), FileuploadUtils.FILE_ENCODING));
            writer.println(realfilename);
            writer.flush();
            writer.close();
            this.filebean = new FileuploadBean();
            this.filebean.setFolderName(this.folderName);
            this.filebean.setFileId(fileId);
            this.filebean.setFileName(realfilename);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    public void initField() {
        this.attachmentName = new ALStringField();
        this.attachmentName.setFieldName("\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb\u540d");
        this.attachmentName.setTrim(true);
    }

    private String getNewAttachmentFolderName(File folder) {
        int maxNum = 1;
        String[] filenames = folder.list();
        File file = null;
        int tmpInt = 1;
        int length = filenames.length;
        for (int i = 0; i < length; ++i) {
            file = new File(folder.getAbsolutePath() + File.separator + filenames[i]);
            if (!file.isDirectory()) continue;
            try {
                tmpInt = Integer.parseInt(file.getName());
                if (maxNum > tmpInt) continue;
                maxNum = tmpInt + 1;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return Integer.toString(maxNum);
    }

    private String getNewAttachmentFileName(File folder) {
        int maxNum = 1;
        String[] filenames = folder.list();
        File file = null;
        int tmpInt = 1;
        int length = filenames.length;
        for (int i = 0; i < length; ++i) {
            file = new File(folder.getAbsolutePath() + File.separator + filenames[i]);
            if (!file.isFile() || file.getName().endsWith(".txt")) continue;
            try {
                tmpInt = Integer.parseInt(file.getName());
                if (maxNum > tmpInt) continue;
                maxNum = tmpInt + 1;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return Integer.toString(maxNum);
    }

    public FileuploadBean getNewAttachmentFile() {
        return this.filebean;
    }
}

