/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.cellular.util;

import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALCellularUtils;
import java.security.Principal;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.services.JetspeedUserManagement;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import sun.misc.BASE64Encoder;

public class CellularUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellularUtils.class.getName());

    public static EipMCompany getEipMCompany(RunData rundata, Context context) {
        EipMCompany result = null;
        String id = "1";
        try {
            if (id == null || Integer.valueOf(id) == null) {
                logger.debug((Object)"Empty ID...");
                return result;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMCompany.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"COMPANY_ID", (Object)Integer.valueOf(id));
            query.setQualifier(exp);
            List list = dataContext.performQuery((Query)query);
            if (list == null || list.size() == 0) {
                logger.debug((Object)"Not found ID...");
                return result;
            }
            result = (EipMCompany)list.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return result;
    }

    public static String getUrl(String ip, int port, String servername) {
        if (ip == null || ip.length() == 0 || port == -1) {
            return "";
        }
        String protocol = JetspeedResources.getString((String)"access.url.protocol", (String)"http");
        StringBuffer url = new StringBuffer();
        if (port == 80) {
            url.append(protocol).append("://").append(ip).append("/").append(servername).append("/");
        } else {
            url.append(protocol).append("://").append(ip).append(":").append(port).append("/").append(servername).append("/");
        }
        return url.toString();
    }

    public static String getCellularUrl(RunData rundata, Context context) {
        String url;
        ALBaseUser baseUser;
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        try {
            baseUser = (ALBaseUser)JetspeedUserManagement.getUser((Principal)new UserNamePrincipal(jdata.getJetspeedUser().getUserName()));
        }
        catch (JetspeedSecurityException e) {
            e.printStackTrace();
            baseUser = (ALBaseUser)rundata.getUser();
        }
        String servername = rundata.getServletConfig().getServletName();
        String key = baseUser.getUserName() + "_" + ALCellularUtils.getCheckValueForCellLogin((String)baseUser.getUserName(), (String)baseUser.getUserId());
        EipMCompany record = CellularUtils.getEipMCompany(rundata, context);
        String domain = CellularUtils.getUrl(record.getIpaddress(), record.getPort(), servername);
        if (domain != null && domain.length() > 0) {
            String company_id = rundata.getParameters().getString("org", "");
            String endword = company_id == null || "".equals(company_id) ? "" : "portal/org/" + company_id + "/";
            url = CellularUtils.getUrl(record.getIpaddress(), record.getPort(), servername) + endword + "?key=" + key;
        } else {
            url = "";
        }
        return url;
    }

    private static String getSecretMsg(String aipo_server_identity, String aipo_username) {
        String delim = "/";
        Date now_date = Calendar.getInstance().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[5];
        random.nextBytes(bytes);
        BASE64Encoder encoder64 = new BASE64Encoder();
        String nonce = encoder64.encodeBuffer(bytes);
        StringBuffer msg = new StringBuffer();
        msg.append(aipo_username).append(delim).append(aipo_server_identity).append(delim).append(sdf.format(now_date)).append(delim).append(nonce);
        return msg.toString();
    }
}

