/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.cellular;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cellular.util.CellularUtils;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.om.security.UserNamePrincipal;
import org.apache.jetspeed.services.JetspeedUserManagement;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.JetspeedSecurityException;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CellularFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellularFormData.class.getName());
    private ALStringField cellular_url;
    private boolean enableEasyLogin;
    private ALBaseUser baseUser;
    private String url;
    private String org_id;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.enableEasyLogin = false;
        this.org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        try {
            this.baseUser = (ALBaseUser)JetspeedUserManagement.getUser((Principal)new UserNamePrincipal(jdata.getJetspeedUser().getUserName()));
        }
        catch (JetspeedSecurityException e) {
            e.printStackTrace();
            this.baseUser = (ALBaseUser)rundata.getUser();
        }
        this.url = CellularUtils.getCellularUrl(rundata, context);
    }

    public void initField() {
        this.cellular_url = new ALStringField();
        this.cellular_url.setFieldName("Aipo\u30b5\u30a4\u30c8\u306e\u30a2\u30c9\u30ec\u30b9");
        this.cellular_url.setTrim(true);
    }

    protected void setValidator() {
    }

    protected boolean validate(ArrayList msgList) {
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        String uid = this.baseUser.getCelluarUId();
        this.enableEasyLogin = uid != null && uid.length() > 0;
        this.cellular_url.setValue(this.url);
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        boolean res = false;
        this.cellular_url.setValue(this.url);
        try {
            if (this.url == null || this.url.length() == 0) {
                msgList.add("Aipo\u30b5\u30a4\u30c8\u306e\u30a2\u30c9\u30ec\u30b9\u304c\u672a\u8a2d\u5b9a\u306e\u305f\u3081\u3001\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002Aipo\u306e\u7ba1\u7406\u62c5\u5f53\u8005\u306b\u304a\u554f\u3044\u5408\u308f\u305b\u304f\u3060\u3055\u3044\u3002Aipo\u30b5\u30a4\u30c8\u306e\u30a2\u30c9\u30ec\u30b9\u306f\u3001\u7ba1\u7406\u753b\u9762\u3067\u8a2d\u5b9a\u3067\u304d\u307e\u3059\u3002");
                return false;
            }
            ALEipUser user = ALEipUtils.getALEipUser((RunData)rundata);
            ArrayList<ALEipUser> memberList = new ArrayList<ALEipUser>();
            memberList.add(ALEipUtils.getALEipUser((RunData)rundata));
            List destMemberList = ALMailUtils.getALEipUserAddrs(memberList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)true);
            String subject = "[Aipo] \u643a\u5e2f\u96fb\u8a71\u7528\u30ed\u30b0\u30a4\u30f3URL";
            String body = this.createMsgForCellPhone(this.url);
            res = ALMailUtils.sendMailDelegate((String)this.org_id, (int)((int)user.getUserId().getValue()), (List)destMemberList, null, (String)subject, null, (String)body, (int)2, (ArrayList)msgList);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return res;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    private String createMsgForCellPhone(String url) {
        String CR = System.getProperty("line.separator");
        StringBuffer body = new StringBuffer("Aipo\u304b\u3089\u306e\u304a\u77e5\u3089\u305b\u3067\u3059\u3002\u4ee5\u4e0b\u306b\u8a18\u8f09\u3055\u308c\u305fURL\u304b\u3089Aipo\u306b\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        body.append("\u30ed\u30b0\u30a4\u30f3\u3059\u308b\u3068\u304d\u306b\u306f\u901a\u5e38\u4f7f\u7528\u3057\u3066\u3044\u308b\u30ed\u30b0\u30a4\u30f3\u30d1\u30b9\u30ef\u30fc\u30c9\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002").append(CR).append(CR);
        body.append(url).append(CR);
        return body.toString();
    }

    public ALStringField getCellularUrl() {
        return this.cellular_url;
    }

    public boolean enableEasyLogin() {
        return this.enableEasyLogin;
    }
}

