<?php
// PostgresDBOޥ͡
// $Id: dbo_pgsql.inc,v 1.7 2004/04/30 08:25:04 atsushifx Exp $

class DBO_pgsql {
	/**
	* ꤷDBơ֥Υեɰ
	*/
	function getFields($db, $table)
	{
		if (!is_object($db) || (get_class($db)!= "db_pgsql")) return aglib::raiseError('AGERR_DB0101');	
		$sql = "select attnum, attname, typname, attlen
	from pg_class c, pg_attribute a, pg_type t
	where c.oid = a.attrelid and t.oid=a.atttypid and
				attnum > 0 and 
				relname='$table'
	order by attnum";
		$res = $db->Query($sql);
		if (DB::isError($res))	return $ret;
		$fields = array();
		while ($row = $res->FetchRow(DB_FETCHMODE_ASSOC)) {
			$key = $row["attname"];
			$type = $this->convertType($row["typname"], $row["attlen"]);
			if (!$type)  return aglib::raiseError('AGERR_DB0111'); // Unknown Data Type
			$fields[$key] = $type;
		}
		if ($fields == array())  return aglib::raiseError('AGERR_DB0110');
		return $fields;
	}
	
	/**
	* ̾DB̤Υ̾Ѵ
	* @param string ̾(DB)
	* @param integer ǡ
	* @return string ̾(DB)
	*/
	function convertType($type_org, $len)
	{
		$type = null;
		switch ($type_org){
		case "int":
		case "int2":
		case "int4":
			if ($len == 1) {
				$type = "boolean";
			} else {
				$type = "integer";
			}
			break;
		
		case "text":
		case "char":
		case "varchar":
			if ($len == 1) {
				$type = "boolean";
			} else {
				$type = "string";
			}
			break;

		case "date":
			$type = "date";
			break;

		case "time":
			$type = "time";
			break;

		case 'datetime':
		case 'timestamp':
			$type = 'datetime';
			break;

		case 'float':
		case 'double':
		case 'real':
			$type = 'float';
			break;

		case 'decimal':
		case 'money':
		case 'numeric':
			$type = 'decimal';
			break;
		
		default:
			$type = false;
		}
		return $type;
	}
}
?>
