#!/usr/bin/perl
use lib "../lib";
use lib "../extlib";
use Walrus::Session::Lite;

my %session;
my $session_dir = "../session/";

#セッションをたちあげる
tie(%session, 'Walrus::Session::Lite', $session_dir);
$session{'latest_login'} = time();

#自分のセッションIDを取得
# -> cookieにいれて送信すべき
my $session_id = $session{'_session_id'};

#セッションを終了し保存する。
untie %session;
my $result = tied(%session)->delete_expired(3 * 24 * 60 * 60); # 3日以上更新のないセッションは破棄


#cokieを通じてclientから取得したsession IDを使って session再開
tie(%session, 'Walrus::Session::Lite', $session_dir, $session_id);
$session{'latest_login'} = time();






