#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# $Id: outgoing.cgi,v 1.6 2005/07/01 08:19:41 slash5234 Exp $

use strict;

use lib("./extlib");
use CGI qw(-unique_headers);
$CGI::DISABLE_UPLOADS = 1;
$CGI::POST_MAX = 102_400;
use CGI::Session qw(-ip_match);
use HTML::Template;
use Error qw(:try);

use lib("./lib");
use Affelio;
use Affelio::SNS::Handshaker_c;
use Affelio::misc::CGIError;
use Affelio::misc::Debug;
use Affelio::misc::Time;
use Affelio::misc::MyCrypt;
use Affelio::misc::NetMisc;
use Affelio::misc::WebInput;

debug_print("outgoing.cgi: start.\n");
my $q = new CGI;

############################################################################
#Load Affelio
############################################################################
my $cfg_dir = ".";
my $af;
try{
    $af = new Affelio(ConfigDir => $cfg_dir);
}catch Error with{
    my $e = shift;
    error($q, "Affelio load error.\n" . $e);
};
my $wi = new Affelio::misc::WebInput(); 

############################################################################
#Check session w/ cookie
############################################################################
my $sid = $q->cookie("affelio-$af->{user__nickname}");
my $session = new CGI::Session(undef, 
			       $sid, 
			       {Directory=> $af->{site__session_dir}});

my $visitor_type="pb";
my $visitor_nickname="anonymous";
my $visitor_afid="";

if($session){
    $visitor_type = $session->param("type");
    $visitor_nickname = $session->param("user_nickname");
    $visitor_afid = $session->param("user_afid");
}
debug_print("outgoing.cgi: visitor_type=      $visitor_type");
debug_print("outgoing.cgi: visitor_nickname=  $visitor_nickname");
debug_print("outgoing.cgi: visitor_afid=      $visitor_afid");

############################################################################
#Main
############################################################################

#########################################
# Retrieve user's IP current address
my $user_addr = $q->remote_addr;
my $user_addr_is_private = check_private_IP_addr($user_addr);
debug_print("outgoing.cgi: user's IP= $user_addr\n");
debug_print("outgoing.cgi: user's IP privateflag= $user_addr_is_private\n");

#########################################
# Retrieve destination URL
my $dest_URL = $wi->PTN_URL($q->param("dest_url"));
debug_print("outgoing.cgi: dst_URL=$dest_URL");

#########################################
# retrieve passAB
my $passAB="";
try{
    $passAB = $af->{fm}->get_attribute_by_afid($dest_URL, "password");
}catch Error with{
    my $e = shift;
    error($q, "Error from FriendManager.\n" . $e);
};
debug_print("outgoing.cgi: passAB=$passAB\n");
if(!defined($passAB) || $passAB eq ""){
    print $q->redirect($dest_URL);
    exit(1);
}

#########################################
# Put this forwarding information into my DB
# so that we can logout this session in the future.
# XXX

#########################################
#Output HTTP reply (Location header).
#
# Location-header:
#  http://siteB.com/bin/incoming.cgi?session=(1)&referrer=(2)
#
#1.PassAB(timestamp, 
#         expire,  
#         browser's IP, 
#         AF_ID,             Who is accessing?
#         nickname,          Who is accessing?
#         type)
#
#2.URL(A)               Where is this forwarding from?

my $plain_msg = "";
if($visitor_type eq "self"){
    $plain_msg = get_timestamp()    . "*" . 
	get_expire_stamp(1,0,0)     . "*" . 
	$q->remote_addr             . "*" . 
	url_encode($visitor_afid)       . "*" . 
	url_encode($visitor_nickname)   . "*" . 
	"self" .'*';
}elsif($visitor_type eq "f1"){
    $plain_msg = get_timestamp()    . "*" . 
	get_expire_stamp(1,0,0)     . "*" . 
	$q->remote_addr             . "*" . 
	url_encode($visitor_afid)       . "*" . 
	url_encode($visitor_nickname)   . "*" . 
	"f1" . '*';
}elsif($visitor_type eq "f2"){
    $plain_msg = get_timestamp()    . "*" . 
	get_expire_stamp(1,0,0)     . "*" . 
	$q->remote_addr             . "*" . 
	url_encode($visitor_afid)       . "*" . 
	url_encode($visitor_nickname)   . "*" . 
	"f2" . '*';
}else{
    $plain_msg = get_timestamp()    . "*" . 
	get_expire_stamp(1,0,0)     . "*" . 
	$q->remote_addr             . "*" . 
	url_encode($visitor_afid)         . "*" . 
	url_encode($visitor_nickname)     . "*" . 
	"pb" . '*';
}
debug_print("outgoing.cgi: plain_msg= $plain_msg\n");

#Encrypt
my $cipher_msg = url_encode( msg_encrypt( $plain_msg, $passAB ) );
debug_print("outgoing.cgi: cipher_msg= $cipher_msg\n");

#Build up URL
my $forwarding_to = "$dest_URL/incoming.cgi?"
    . "forward_id=$cipher_msg" 
    . "&" 
    . "referrer=$af->{site__web_root}";
debug_print("outgoing.cgi: forwarding_to= $forwarding_to\n");


############################################################################
#Output
############################################################################
if($user_addr_is_private){
    #This access is from some private IP address.
    #It means the user may have some problem in 
    #session forwarding when the user is forwarded
    #to the destination Affelio. So warn the user.

    my $TMPL_FILE = "$af->{site__fs_root}/templates/$af->{site__template}/" 
	."owner_side/outgoing_warn.tmpl";

    my $tmpl = new HTML::Template( filename => $TMPL_FILE,
				   die_on_bad_params => 0);    

    my $warning_message = "<AF_M text='_SYS_WARN_OUTGOING_PRIV_IP' param='$user_addr'><P><A HREF=\"$forwarding_to\">Destination Affelio</A>: <AF_M text='_SYS_WARN_OUTGOING_PRIV_IP2'>";
    $tmpl->param(message => $warning_message);
    $tmpl->param(forwarding_to => $forwarding_to);
    $tmpl->param(tmpl_path => "$af->{site__web_root}/templates/$af->{site__template}/owner_side/");
    print "Content-type: text/html; charset=UTF-8\n";
    print "Pragma: no-cache", "\n\n"; 
    print $af->translate_templateL10N($tmpl->output);

}else{
    print $q->redirect($forwarding_to);
}
