# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: AffelioApp.pm,v 1.10 2005/07/01 02:00:06 slash5234 Exp $

package AffelioApp;
{
    use strict;
    use lib("../extlib");
    use Error qw(:try);
    use lib("../../extlib");
    use HTML::Template;
    use CGI::Session;
    use CGI;
    use lib("../lib");
    use Affelio;
    use Affelio::misc::Debug;
    use Affelio::exception::DBException;

    ######################################################################
    #Constructor
    ######################################################################
    sub new{
	my $class = shift;
	my %param = @_;

	debug_print("AffelioApp::new: start.");

	############################
	#app__fs_root, cfg_path
	############################
	my $app__fs_root = $param{ConfigDir};
	my $cfg_path = "$app__fs_root/AF_app.cfg";
	debug_print("AffelioApp::new: ConfigDir =$app__fs_root");
	debug_print("AffelioApp::new: cfg_path  =$cfg_path");

	############################
	#CGI
	############################
	my $cgi = $param{cgi};

	############################
	#Install name
	############################
	my $install_name = $app__fs_root;
	$install_name =~ s|/(.*)/||g;
	debug_print("AffelioApp::new: install_name=$install_name");

	############################
	#Load Affelio
	############################
	my $af = new Affelio(ConfigDir => "$app__fs_root/../../",
			     Caller    => $install_name);

	############################
	#app__web_root
	############################
	my $app__web_root = "$af->{site__web_root}/apps/$install_name";
	debug_print("AffelioApp::new: web_root=$app__web_root");
	debug_print("AffelioApp::new: fs_root =$app__fs_root");

	############################
	#create userdata directory as needed
	############################
	if(-e "$af->{site__user_dir}/appdata/$install_name"){
	}else{
	    if (-d "$af->{site__user_dir}/appdata/"){
		if (-w "$af->{site__user_dir}/appdata/"){
		    my $ret =
			mkdir("$af->{site__user_dir}/appdata/$install_name", 0777);
		    if(!$ret){
			error("Cannot make userdata/appdata/$install_name!");
		    }
		}else{
		    error("Cannot make userdata/appdata/ is NOT writable!");
		}
	    }else{
		my $ret =
		    mkdir("$af->{site__user_dir}/appdata/", 0777);
		if(!$ret){
		    error("Cannot make userdata/appdata/!");
		}
		$ret =
		    mkdir("$af->{site__user_dir}/appdata/$install_name", 0777);
		if(!$ret){
		    error("Cannot make userdata/appdata/$install_name!");
		}
	    }
	}

	############################
	#Cookie check!
	############################
	my $sid = $cgi->cookie("affelio-$af->{user__nickname}");
	my $session = new CGI::Session(undef, 
				       $sid, 
				       {Directory=> $af->{site__session_dir}});
	my $visitor_type="pb";
	my $visitor_nickname="anonymous";
	my $visitor_afid="";
	if($session){
	    $visitor_type = $session->param("type");
	    $visitor_nickname = $session->param("user_nickname");
	    $visitor_afid = $session->param("user_afid");
	}
	if($visitor_type eq ""){
	    $visitor_type="pb";
	}
	debug_print("AffelioApp::new: visitor_type=      $visitor_type");
	debug_print("AffelioApp::new: visitor_nickname=  $visitor_nickname");
	debug_print("AffelioApp::new: visitor_afid=      $visitor_afid");

	my $install_title = $af->{am}->{apps}->{$install_name}->{install_title};

	my $dbh = $af->openAppDB($install_name);

	#bless
	my $self = {cfg_path => $cfg_path,
		    app__fs_root => $app__fs_root, 
		    app__web_root => $app__web_root, 
		    install_name => $install_name,
		    install_title => $install_title,
		    af => $af,
		    cgi => $cgi,
		    session => $session,
		    visitor_type => $visitor_type,
		    visitor_nickname => $visitor_nickname,
		    visitor_afid => $visitor_afid,
		    userdata_dir => "$af->{site__user_dir}/appdata/$install_name/",
		    userdata_dbh => $dbh
		    };
	bless $self, $class;

	############################
	#Am I in the owner mode?
	############################
	debug_print("AffelioApp::new: cfg_path  =$cfg_path");
	my $Config = Config::Tiny->new();

	try{
	    $Config = Config::Tiny->read($cfg_path);
	}catch Error with{
	    throw Affelio::exception::SystemException("AFApp.cfg not found");
	}
	my $rootproperty = $Config->{_}->{rootproperty};
	my $owner_index = $Config->{application}->{owner_index};
	debug_print("AffelioApp::new: owner_index  =$owner_index");

	if($cgi->self_url =~/$owner_index/){ 
	    $self->set_owner_mode();
	}

	############################
	debug_print("AffelioApp::new: end.");
	return $self;
    }

    ######################################################################
    #get_userdata_dir
    ######################################################################
    sub get_userdata_dir{
	my $self = shift;
	return($self->{userdata_dir});
    }

    ######################################################################
    #get_userdata_dbh
    ######################################################################
    sub get_userdata_dbh{
	my $self = shift;
	return($self->{userdata_dbh});
    }


    ######################################################################
    #check_access
    ######################################################################
    sub check_access{
	my $self = shift;
	my $action_type = shift;

	my $ret=0;
	try{
	    $ret=
	    $self->{af}->{am}->get_summed_app_perm($self->{visitor_afid},
						   $self->{visitor_type},
						   $self->{install_name},
						   $action_type);
	}catch Affelio::exception::DBException with{

	};

	return($ret);
    }

    ######################################################################
    #set_owner_mode:   Flag this AffelioApp as "owner" mode.
    ######################################################################
    sub set_owner_mode{
	my $self = shift;
	$self->{af}->set_owner_mode();
    }

    ######################################################################
    #get_visitor_info
    ######################################################################
    sub get_visitor_info{
	my $self = shift;
	my $info_name = shift;
	
	if($info_name eq "nickname"){
	    return($self->{visitor_nickname});
	}elsif($info_name eq "afid"){
	    return($self->{visitor_afid});
	}elsif($info_name eq "type"){
	    return($self->{visitor_type});
	}
	return;
    }
    
    ######################################################################
    #get_session_param
    ######################################################################
    sub get_session_param{
	my $self = shift;
	my $param_name = shift;

	return($self->{session}->param($param_name));
    }
    
    ######################################################################
    #set_session_param
    ######################################################################
    sub set_session_param{
	my $self = shift;
	my $param_name = shift;
	my $param_val = shift;

	$self->{session}->param($param_name, $param_val);
	return;
    }
    
    ######################################################################
    #get_site_info
    ######################################################################
    sub get_site_info{
	my $self = shift;
	my $info_name = shift;

	if($info_name eq "web_root"){
	    return($self->{af}->{site__web_root});
	}
	return;
    }

    ######################################################################
    #get_owner_info
    ######################################################################
    sub get_owner_info{
	my $self = shift;
	my $info_name = shift;

	if($info_name eq "nickname"){
	    return($self->{af}->{user__nickname});
	}elsif($info_name eq "afid"){
	    return($self->{af}->{site__web_root});
	}
	return;
    }

    ######################################################################
    #get_HTML_header
    ######################################################################
    sub get_HTML_header{
	my $self = shift;
	my $app__page_title = shift;

	my $af = $self->{af};

	#Set template file name
	my $TMPL_FILE = "$af->{site__fs_root}/templates_dyn/Header.tmpl";
	#Set data for template
	my %output_data = ();
	$output_data{'app__css_path'} = $self->{app__web_root};
	$output_data{'app__page_title'} = $app__page_title;
	$output_data{"site__skin_dir"} = $af->{site__web_root} . "/skins/" . $af->{userpref__skin};
	$output_data{'site__web_root'} = $af->{site__web_root};
	$output_data{'site__locale'} = $af->{site__locale};

	$af->get_module_list(\%output_data, $self->{visitor_afid},$self->{visitor_type});
	$af->get_guest_owner_list(\%output_data);

	#Initiate Template
	my $tmpl = new HTML::Template( filename => $TMPL_FILE,
				       die_on_bad_params => 0);
	foreach my $data_key (keys(%output_data)) {
	    debug_print("$data_key = $output_data{$data_key}");
	    $tmpl->param($data_key => $output_data{$data_key});
	} 

	my $final_out = $af->translate_templateL10N($tmpl->output)
	    . '<div class="afPubMain">' . "\n";

	return($final_out);

    }

    ######################################################################
    #get_HTML_footer
    ######################################################################
    sub get_HTML_footer{
	my $self = shift;
	my $af = $self->{af};

	#Set template file name
	my $TMPL_FILE = "$af->{site__fs_root}/templates_dyn/Footer.tmpl";
	my $tmpl = new HTML::Template(filename => $TMPL_FILE);

	my $final_out = "</div><!--afPubMain-->"
	    . $af->translate_templateL10N($tmpl->output);

	return($final_out);
    }

    ######################################################################
    #get_app_info
    ######################################################################
    sub get_app_info{
	my $self = shift;
	my $info_name = shift;

	if($info_name eq "install_title"){
	    return($self->{install_title});
	}
	return;
    }

    ######################################################################
    #get_URL
    ######################################################################
    sub get_URL{
	my $self = shift;
	my $af = $self->{af};
	my $name = shift;

	my $ret="";
	if(($name eq "access_control") && ($self->{visitor_type} eq "self")){
	    $ret = $af->{site__web_root} . "/admin.cgi?mode=access_control_apps&mode2=show_app&app_name=" . $self->{install_name};
	}

	return($ret);
    }

    ######################################################################
    #Destructor
    ######################################################################
    sub DESTROY{
	my $self = shift;
    }
    
}#package
1;
##########################################################################
