# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: WebInput.pm,v 1.6 2005/07/01 02:00:10 slash5234 Exp $
use strict;

package Affelio::misc::WebInput;
{
    use lib("../../../lib/");
    use Affelio::exception::TaintedInputException;
    use Affelio::misc::Debug qw(debug_print);

    ######################################################################
    sub new{
	my $class = shift;
	my %param = @_;

	my $self = {locale => "ja"};
	bless $self, $class;

	return($self);
    }

    ######################################################################
    sub PTN_through{
	my $self = shift;
	my $in = shift;

	$in =~ /(.*)/;
	return ($1);
    }

    ######################################################################
    sub PTN_visitor_type{
	my $self = shift;
	my $in = shift;

	$in =~ /([A-Za-z0-9]*)/;
	return ($1);
    }

    ######################################################################
    sub PTN_num{
	my $self = shift;
	my $in = shift;

	$in =~ /(\d+)/;
	return ($1);
    }


    ######################################################################
    sub PTN_nickname{
	my $self = shift;
	my $in = shift;

	$in =~ /([A-Za-z0-9\-\_]*)/;
	return ($1);
    }

    ######################################################################
    sub PTN_word{
	my $self = shift;
	my $in = shift;

	$in =~ /([A-Za-z0-9\-\_\.]*)/;
	return ($1);
    }

    ######################################################################
    sub PTN_mode{
	my $self = shift;
	my $in = shift;

	$in =~ /([A-Za-z0-9\-\_]*)/;
	return ($1);
    }

    ######################################################################
    sub PTN_getcontent_content{
	my $self = shift;
	my $in = shift;

	$in =~ /([A-Za-z0-9\-\_\.\/]*)/;
	return ($1);
    }

    ######################################################################
    sub PTN_basefilename{
	my $self = shift;
	my $in = shift;
	$in =~ /([A-Za-z0-9\-\_]+\.[A-Za-z0-9]+)/;
#	debug_print("==============$1");
	return ($1);
    }

    ######################################################################
    sub PTN_jpg_filename{
	my $self = shift;
	my $in = shift;
	$in =~ /([A-Za-z0-9\-\_]*\.(jpg)|(JPG)|(JPEG)|(jpeg))/;
#	debug_print("==============$1");
	return ($1);
    }

    ######################################################################
    sub PTN_dirname{
	my $self = shift;
	my $in = shift;
	$in =~ /([A-Za-z0-9\-\_\.\/\s]*)/;
#	debug_print("==============$1");
	return ($1);
    }



    ######################################################################
    sub PTN{
	my $in = shift;

	if($in ne ""){
	    if ($in =~ /([\w\-\_]+)/){
		return($1);
	    }else{
		throw Affelio::exception::TaintedInputException("Tainted input!");
	    }
	}
    }

    ######################################################################
    sub PTN_URL{
	my $self = shift;
	my $in = shift;

       my @http = $in =~ /s?https?:\/\/[-_.!~*'()a-zA-Z0-9;\/?:\@&=+\$,%#]+/g;#'
       return($http[0]);
    }

    ######################################################################
    sub translate_URL_to_HTML{
	my $self = shift;
	my $in = shift;

       $in =~ s/(s?https?:\/\/[-_.!~*'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)/<A HREF="$1">$1<\/A>/g;#'
       return($in);
    }
    

    ######################################################################
    sub distill_URL{
       my $text = shift;
       if($text =~ /(s?https?:\/\/[-_.!~*'()a-zA-Z0-9;\/?:\@&=+\$,%#]+)/){ #'
           return($1);
       }else{
           return("");
       }

    }

    ######################################################################
    sub escape_HTML{

    }

    ######################################################################
    sub escape_filename {
	my $forbedden = '\\\/\*\?\|"<>:,;% ';
	my ($filename) = @_;
	$filename =~ s/([$forbedden])/'%' . unpack('H2', $1)/eg;
	return $filename;
    }

    ######################################################################
    sub delete_HTML{
	my $str = shift;
	my $text_regex = q{[^&lt;]*};
        my $tag_regex = "";
        my $tag_regex_ = "";
        my $text_tmp="";

	my $result = '';
	while ($str =~ /($text_regex)($tag_regex)?/gso) {
	    last if $1 eq '' and $2 eq '';
	    $result .= $1;
	    my $tag_tmp = $2;

	    if ($tag_tmp =~ /^&lt;(XMP|PLAINTEXT|SCRIPT)(?![0-9A-Za-z])/i) {
		$str =~ /(.*?)(?:&lt;\/$1(?![0-9A-Za-z])$tag_regex_|$)/gsi;
			       ($text_tmp = $1) =~ s/&lt;/&amp;lt;/g;
			       $text_tmp =~ s/&gt;/&amp;gt;/g;
			       $result .= $text_tmp;
            }
        }

        return($result);
    }        
}
1;
