# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: Time.pm,v 1.6 2005/07/01 02:00:10 slash5234 Exp $

package Affelio::misc::Time;
{
    use strict;
    use Exporter;
    @Affelio::misc::Time::ISA = "Exporter";
    @Affelio::misc::Time::EXPORT = qw (get_today get_timestamp get_past_timestamp get_expire_stamp timestamp2string timestamp2stringB);

    sub timestamp2string{
	my $timestamp = shift;

	my $year = substr ($timestamp, 0, 4);
	my $mon  = substr ($timestamp, 4, 2);
	my $mday = substr ($timestamp, 6, 2);
	my $hour = substr ($timestamp, 8, 2);
	my $min  = substr ($timestamp, 10, 2);
	my $sec  = substr ($timestamp, 12, 2);

	return("$year/$mon/$mday $hour:$min");
    }

    sub timestamp2stringB{
	my $timestamp = shift;

	my $mon  = substr ($timestamp, 4, 2);
	my $mday = substr ($timestamp, 6, 2);
	my $hour = substr ($timestamp, 8, 2);
	my $min  = substr ($timestamp, 10, 2);
	my $sec  = substr ($timestamp, 12, 2);

	return("$mon/$mday $hour:$min");
    }



    sub get_timestamp{
	my ($sec, $min, $hour, $mday, $mon, $year,
	    $wday, $yday, $isdst) = localtime(time());
	
	return sprintf("%04d%02d%02d%02d%02d%02d", 
		       $year+1900, $mon+1, $mday,
		       $hour, $min, $sec);
    }


    sub get_past_timestamp{
	my $past_sec = shift;
	my ($sec, $min, $hour, $mday, $mon, $year,
	    $wday, $yday, $isdst) = localtime(time()-$past_sec);
	
	return sprintf("%04d%02d%02d%02d%02d%02d", 
		       $year+1900, $mon+1, $mday,
		       $hour, $min, $sec);
    }


    sub get_today{
	my ($sec, $min, $hour, $mday, $mon, $year,
	    $wday, $yday, $isdst) = localtime(time());
	
	return sprintf("%04d%02d%02d000000",
		       $year+1900, $mon+1, $mday);
    }

    
    sub get_expire_stamp{
	my $p_mday = shift;
	my $p_hour = shift;
	my $p_min = shift;
	
	my ($sec, $min, $hour, $mday, $mon, $year,
	    $wday, $yday, $isdst) = localtime(time());
	
	$year+= 1900;
	$mon += 1;
#	$mday += 1;
	
	$min += $p_min;
	if($min >= 60){
	    $min -= 60;
	    $hour+=1;
	}
	$hour += $p_hour;
	if($hour >= 24){
	    $hour -= 24;
	    $mday+= 1;
	}
	$mday += $p_mday;
	
	return sprintf("%04d%02d%02d%02d%02d%02d", 
		       $year, $mon, $mday,
		       $hour, $min, $sec);
    }


}
1;
