# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: en_us.pm,v 1.16 2005/07/04 01:46:17 slash5234 Exp $

package Affelio::misc::L10N::en_us;
{
    use strict;
    use lib("../../../../extlib");
    use lib("../../../../lib");
    use Affelio::misc::L10N;
    #
    use vars qw(@ISA %Lexicon);

    sub encoding { "UTF-8" }

    @ISA = qw(Affelio::misc::L10N);

    %Lexicon = (
		##########################################################
		#System
		##########################################################
		'_SYS_ENCODING_DUMMY' =>'',
		'_SYS_attr_opened' =>'Yes',
		'_SYS_attr_closed' =>'',

		##########################################################
		#Setup wizard
		##########################################################
		'_SETUP_title_10' => 'Welcome to Affelio!',
		'_SETUP_msg_10' => 'Welcome to the Affelio setup wizard! You can set up Affelio easily and quickly by following the wizard screen.<P><B>This setup wizard is <FONT COLOR="red">NOT for upgrade install</FONT>. Please read release note document for upgrade install.</B><P>Click "Next" and proceed.',
		#
		'_SETUP_title_30' => 'On the GPL2.0 version',
		'_SETUP_msg_30' => '<B><FONT COLOR="red">Caution!!</FONT></B>&nbsp;&nbsp;This Affelio is "Affelio (GPL version)" which will be licensed for the customer via <A HREF="http://www.gnu.org/copyleft/gpl.html" target="_blank">GNU General Public License (GPL) 2.0</A>.</B> Push the "Accept" button and go to the next screen, <B>ONLY IF you understand this licensing policy.</B> <P><HR><P>NO WARRANTY (from GPL2.0)<BR>11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION. <P>12.  IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.<P><HR><P>Affelio is software with dual licensing based on GPL2.0 and Affelio Commercial License. Visit <A HREF="http://affelio.jp/modules/tinyd5/" target="_blank">our web page on the licenses</A>.',
		#
		'_SETUP_title_50' => 'Required Perl Modules',
		'_SETUP_msg_50_1' => 'Followings are the Perl modules necessary for Affelio installation. If you can see any <FONT COLOR="red">NOT INSTALLED</FONT> module, install the module before you go to the next screen. <P>',
		'_SETUP_msg_50_2' => 'Click "Next" when everything is ok.', 
		'_SETUP_msg_50_3' => '</blockquote>Also, <B>one of the following two modules</B> needs to be installed as a database driver module. If the database driver you want to use is <FONT COLOR="red">NOT INSTALLED</FONT>, install it before you go to the next screen.<blockquote>',
		'_SETUP_check_50_err1' => 'You need to install some Perl modules more.',
		#
		'_SETUP_title_100' => 'Configuration File',

		'_SETUP_msg_100' => 'On your web server, create a file named "affeio.cfg" with writable file permission (example: 666) in the same directory as "stup.cgi"<P>Also, set permission writable (example: 700 or 777) for the following directories.<UL><LI>userdata/<LI>session/<LI>skins/<LI>templates_dyn/<UL>',

		'_SETUP_check_100_err1' => '<LI>"affelio.cfg" not found.<BR>On your web server, create a file named "affeio.cfg" with writable file permission (example: 666) in the same directory as "stup.cgi"', 
		'_SETUP_check_100_err2' => '<LI>"affelio.cfg" is not readable.<BR>Set permission of "affelio.cfg" redable (example: 666).',
		'_SETUP_check_100_err3' => '<LI>"affelio.cfg" is not writable.<BR>Set permission of "affelio.cfg" writable (example: 666).',
		'_SETUP_check_100_err4' => '<LI>[_1] is not writable. Configure the file writable.</P>',
		'_SETUP_check_100_err5' => '<LI>[_1] is not readable. Configure the file readable.</P>',
		#
		'_SETUP_title_200' => 'External Programs',
		'_SETUP_msg_200' => '<P>The setup program detected place of \"sendmail\" command as follows. Click \"Next\" if you are okay with this.</P><P>Input the place (path) if the detected result is blank. Ask your web server\'s administrator if you don\'t know the path.</P>',
		'_SETUP_check_200_err1' => 'sendmail is not found in [_1]!',
		#
		'_SETUP_title_350' => 'Choose your database',
		'_SETUP_msg_350' => 
		'<P>Choose your database.</p>'
		. '<P><INPUT TYPE="radio" NAME="dbtype" VALUE="mysql">MySQL'
		. '<UL><TABLE BORDER=0>'
		. '<TR><TD>DB name: </TD><TD><INPUT TYPE="text" NAME="mysql_dbname"></TD></TR>'
		. '<TR><TD>DB username: </TD><TD><INPUT TYPE="text" NAME="mysql_username"></TD></TR>'
		. '<TR><TD>password: </TD><TD><INPUT TYPE="text" NAME="mysql_password"></TD></TR>'
		. '<TR><TD>DB hostname: </TD><TD><INPUT TYPE="text" NAME="mysql_hostname">(optional)</TD></TR>'
		. '<TR><TD>port: </TD><TD><INPUT TYPE="text" NAME="mysql_port">(optional)</TD></TR>'
		. '</TABLE></UL>'
		. '<P><INPUT TYPE="radio" NAME="dbtype" VALUE="sqlite" checked>SQLite',
		#

		'_SETUP_title_400' => 'Site Owner\'s Login Information',
		'_SETUP_msg_400' => '<P>Decide and input your user name and password which are necessary for login as the site owner of this Affelio. Input your email address. </P><P>Also, decide and input your nickname on the Affelio. The nickname will be opended for the global Affelio network.</P>'
		. '<P><TABLE BORDR="0"><TR><TD VALIGN="top">User name: </TD>'
		. '<TD><INPUT TYPE="text" NAME="username" SIZE="30" VALUE=""><BR><font size="-2">(Alphabet and numerical letters)</font></TD></TR>'
		. '<TR><TD VALIGN="top">Password: </TD>'
		. '<TD><INPUT TYPE="text" NAME="password" SIZE="30" VALUE=""><BR><font size="-2">(Alphabet and numerical letters)</font></TD></TR>'
		. '<BR><TR><TD>Email address: </TD>'
		. '<TD><INPUT TYPE="text" NAME="email" SIZE="30" VALUE=""><BR><font size="-2">(Alphabet and numerical letters)</font></TD></TR>'
		. '<TR><TD HIGHT="20">&nbsp;</TD><TD> </TD></TR>'
		. '<TR><TD VALIGN="top">Nickname: </TD>'
		. '<TD><INPUT TYPE="text" NAME="nickname" SIZE="30" VALUE="" onBlur="checkNickname2(this)"><BR><font size="-2">(Alphabet and numerical letters)</font></TD></TR>'
		. '</TABLE>', 
		#
		'_SETUP_title_500' => 'Congrat! Setup is complete.',
		'_SETUP_msg_500' => '<P>Congratulations! Setup is complete. Your Affelio page is <A HREF="[_1]">[_1]</A>. Log onto your page and configure your profile!</P><P>Delete "setup.cgi" and "upgrade-*.cgi"s from the web server since it is not necessary any more and since it can be a security issue.</P>',
		#
		'_SETUP_group_dear_friend' => 'dear friend',
		#
		'_SETUP_err_module_notfound' => '[_1]&nbsp;&nbsp;&nbsp;<FONT COLOR="red"><B>NOT INSTALLED</B></FONT><BR>',
		'_SETUP_module_found' => '[_1]&nbsp;&nbsp;&nbsp;OK. installed. ([_2])<BR>',

		##########################################################
		#Friend class
		##########################################################
		'_VISITOR_TYPE_PB' => 'Public Guest',
		'_VISITOR_TYPE_F2' => 'Friend of A Friend',
		'_VISITOR_TYPE_F1' => 'Friend',
		'_VISITOR_TYPE_SELF' => 'Site Owner',

		##########################################################
		#Profile
		##########################################################

		##########################################################
		#System information
		##########################################################

		###########################################################
		#Handshake
		###########################################################

		##########################################################
		#owner pages
		##########################################################
		#Top
		'_ADMIN_TOP_EXP' => 'Here is the top page of the Affelio owner page that only the Affelio owner can access. Here you can configure the Affelio settings, such as profile, your friends, or Affelio itself.',
		'_ADMIN_TOP_MYSTATUS' => 'My Greeting',
		'_ADMIN_TOP_MYSTATUS_EXP' => 'Write your recent greeting! Your friends can see it.',
		'_ADMIN_TOP_SEND_LINK_EXP' => 'Request a friend link for another Affelio', 
		'_ADMIN_TOP_SEND_LINK_EXP2' => 'Destination Affelio URL',
		'_ADMIN_TOP_SEND_LINK_EXP3' => 'Send',
		'_ADMIN_TOP_SEND_LINK_EXP4' => 'Your message to the person',
		'_ADMIN_TOP_SEND_INVITATION_EXP'  => 'Send invitation email to my friend',
		'_ADMIN_TOP_SEND_INVITATION_EXP2' => 'Email address: ',
		'_ADMIN_TOP_SEND_INVITATION_EXP3' => 'Send',

		########################
		#Menu

		########################
		"_ADMIN_ACCESS_CONTROL_EXP" => 'Here you can configure who ("friend", "friend of a friend", or other guests) can access which part of your personal information.',
		"_ADMIN_ACCESS_CONTROL_DETAIL_EXP" => '<div class="afPubContentBlock"><div class="afPubContentBlockTitle">What are "friend"、"friend of a friend"、"public guest"?</div><UL><LI><b>Friend</b><BR>Those who you are directly connected to through Affelio.<P><img src ./images/friends.png"><LI><b>Friend of a Friend</b><BR>Those who "your friend" are directly connected to through Affelio.<P><img src="./images/friendsoffriends.png"><LI><b>Public Guest</b><BR>Those who cannot be in the two types above.</UL></div><div class="afPubContentBlock"><div class="afPubContentBlockTitle">What is "Group" for friends?</div><UL>For your friends, you can set access control more flexibly with "groups". For example, if you include a friend, <b>Tom</b>, in <b>group (A)</b>, Tom can access your <B>personal information which you configure to open for either "friend" or "group (A)"</B>.</UL></div>',
		########################
		"_ADMIN_EDIT_SKINS_EXP" => 'ここでは、Publicページ用のデザインスキンに関する設定ができます。<P><UL><LI>インストールされているスキンを選択できます。<LI>現在選択中のスキンをカスタマイズできます。<LI>スキンをZIPファイルとしてバックアップできます。<LI>スキンのZIPファイルをアップロードして、インストールできます。</UL>',
		"_ADMIN_EDIT_SKINS_BACKUP_EXP" => 'ここでは、サーバー上のスキンをZIP形式のスキンパッケージとしてバックアップ (ダウンロード) できます。<OL><LI>まず、バックアップするスキンを選んでください。<LI>もし名前をつけて(違う名前のスキンとして)バックアップしたい場合は、名前を入力してください。<LI>ダウンロードボタンを押してください。</OL>',
		"_ADMIN_EDIT_SKINS_UPLOAD_EXP" => 'ここでは、ZIP形式のスキンパッケージをサーバーへアップロードできます。アップロードされたスキンは以降選択できるようになります。<OL><LI>まず、アップロードするスキンを選んでください。<LI>アップロードボタンを押してください。</OL>.zipファイルをアップロードするとスキンパッケージとして認識されます。.gif, .jpg, .jpeg, .pngファイルをアップロードすると、現在選択しているスキンのディレクトリにアップロードされます。',

		########################
		'_ADMIN_AFFELIO_CONFIG_EXP' =>'Here you can configure your Affelio.',

		'_ADMIN_SYSCONFIG_TOPPAGE_EXP' => 'You can set which module will be the top page, that is URL:<A HREF="[_1]" target="_blank">[_1]</A>',

		'_ADMIN_SYSCONFIG_NOTIFICATION_EXP' => 'Do you want to get email notification when you have a new message in Affelio Messaging?',

		'_ADMIN_SYSCONFIG_HOSTING_EXP' => 'Your preferred Affelio Hosting Service when you invite your friend into the Affelio world. <BR>(Coming Soon!)',


		########################
		"_ADMIN_EDIT_TEMPLATES_EXP" => 'Here, you can edit various template files for the design of your guest pages.',

		########################
		"_ADMIN_EDIT_PROFILE_EXP" => 'Here, you can edit your profile on Affelio. <P><font color="red">You can disclose your profile only to whom you want disclose it. </font>',
		"_ADMIN_EDIT_PROFILE_EXP2" => 'Tips for "Description": Examples are "Private", "Work", "MSN Messenger", or "Skype".', 
		"_ADMIN_EDIT_PROFILE_EXP3" => 'This introduction is opened for public.  All visitor\'s to your Affelio can see it.',
		"_ADMIN_EDIT_PROFILE_EXP4" => 'This introdcution can be access-controled. For instance, write your introduction which you want allow only your friend to access to it.',  

		########################
		'_ADMIN_FRIEND_GRAPH_EXP' => 'あなたの友人関係をグラフで表示します。Javaを使ったテストバージョンです。<P>注意：このグラフは必ずしも最新の友達状態を表すものではありません。ページ下の「リスト更新」ボタンを押すと、最新情報へアップデートする通信を友達と行います。',

		########################
		'_ADMIN_GROUP_FRIENDS_EXP' => '<BR>Here, you can configure which friend belongs which group.',

		'Affelio Messaging' => 'Affelio Messaging',
		'Messages' => 'Messages',
		'_ADM_MSG_FROM' => 'Sender',
		'_ADM_MSG_TO' => 'To:',
		'_ADM_MSG_TITLE' => 'Title:',
		'_ADM_MSG_DATE' => 'Date:',
		'_ADM_MSG_BODY' => 'Body:',

		'_ADM_MSG_EXP' => 'Here you can browse messages from your Affelio or friends in Affelio Network.',

		########################
		'_ADMIN_MANAGE_FRIEND_SHOW_MEMBER_EXP' => 'Write your comment for the friend in the text box below. Comment will be on your Affelio\'s friend list page!',
		'_ADMIN_MANAGE_FRIEND_SHOW_MEMBER_EXP1' => 'Information opened for [_1]',
		'_ADMIN_MANAGE_FRIEND_SHOW_MEMBER_EXP2' => 'As a member of "[_1]"',
		'_ADMIN_MANAGE_FRIEND_SHOW_MEMBER_EXP3' => 'Count out from this group',
		'_ADMIN_MANAGE_FRIEND_SHOW_MEMBER_EXP4' => 'Add membership of other groups',

		########################
		'_ADMIN_UPLOAD_PICTURES_EXP' => 'Here you can upload a picture for your Affelio profile.<BR><BR>Upload a JPEG file with .jpg or .jpeg extension. The maximum size is 150 x 150.<BR><BR><strong>It may take several seconds for upload to be completed, depending on the size of the picture.</strong>',


		########################
		'_ADMIN_ACCESS_LOG_EXP' => '',


		########################
		'_ADM_MSG_FROM' => 'Sender',
		'_ADM_MSG_TITLE' => 'Title',
		'_ADM_MSG_DATE' => 'Date',
		'_ADM_MSG_EXP' => 'Here you can see messages from your Affeilo or your friends.',

		########################
		'_ADMIN_MANAGE_FRIEND_TOP_EXP1' => 'Here you can edit your Affelio friends.<BR> * Write your comment for your friends.<BR> * Check your personal information disclosed for each friend.<BR> * You can adjust disclosure of your personal information by adding /deleting a friend to/from "groups".',
		'_ADMIN_MANAGE_FRIEND_TOP_EXP2' => 'Friends of [_1]',

		########################
		'_ADMIN_MANAGE_APP_TOP_EXP' => '',
		'_ADMIN_MANAGE_APP_TOP_EXP1' => '',
		'_ADMIN_MANAGE_APP_TOP_EXP2' => 'Applications currently installed on this Affelio',
		'DF_visibility' => 'Show in the app. tab',
		'DF_access' => 'Basic access to the app',

		########################
		'_ADMIN_MANAGE_GROUP_TOP_EXP1' => 'Your Groups',
		'_ADMIN_MANAGE_GROUP_TOP_EXP2' => 'Push the button after you input the group name to be added.',
		'_ADMIN_MANAGE_GROUP_TOP_EXP3' => 'Group Name: ',

		##########################################################
		'_SYS_WARN_OUTGOING_PRIV_IP' => 'Warning:<BR>You are currently accessing this Affelio from a private IP address "[_1]". In such a case, note that the Affelio may not forward your login session to the destination Affelio.',
		'_SYS_WARN_OUTGOING_PRIV_IP2' => 'Click this link to manually go to the destination Affelio! :)',

		##########################################################
		'_AUTO' => 1,
		);
}
1;
