# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: Encoding.pm,v 1.3 2005/07/01 02:00:10 slash5234 Exp $

package Affelio::misc::Encoding;
{
    use lib "../../../extlib";
    use Crypt::RC5;
    use Jcode;

    use Exporter;
    @Affelio::misc::Encoding::ISA = "Exporter";
    @Affelio::misc::Encoding::EXPORT = qw (db_encode db_decode);

    ########################################################################
    sub db_encode{
	my $str = shift;

	$str = jcode($str)->mime_encode;
	$str =~ s/\n//g;
	$str =~ s/\r//g;

	return($str);
    }

    ########################################################################
    sub db_decode{
	my $str = shift;

	return(jcode($str)->mime_decode);
    }
    
}
1;
