# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: SendHandshake.pm,v 1.3 2005/07/01 02:00:07 slash5234 Exp $

package Affelio::App::Admin::SendHandshake;
{
    use strict;

    use lib("../../../../extlib/");
    use Error qw(:try);
    use Crypt::DH;
    use MIME::Base64::Perl;
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::Encoding qw(db_encode db_decode);
    use Affelio::misc::Time qw(timestamp2string get_timestamp);
    use Affelio::misc::WebInput;
    use Affelio::SNS::Handshaker_c;
    use Affelio::SNS::Handshaker_tmpDB;
    use Affelio::exception::CommunicationException;

    use Exporter;
    @Affelio::App::Admin::SendHandshake::ISA = "Exporter";
    @Affelio::App::Admin::SendHandshake::EXPORT = qw (send);

    #######################################################################
    #send
    #######################################################################    
    sub send{
	my $af = shift;
	my $cgi = shift;
	my $output_ref = shift;
    	my $wi = new Affelio::misc::WebInput;

	debug_print("SendHandshake::send: start.");

	my $dest_uri = $wi->PTN_URL($cgi->param("dest_uri"));
	my $my_mesg = $cgi->param("my_mesg");

	debug_print("SendHandshake::send: $dest_uri");
	debug_print("SendHandshake::send: $my_mesg");
	
	######################
        #Remove "/" from the end of $dest_uri
        ######################
	$dest_uri =~ s/\/$//;
	my $dest_xml_uri = $dest_uri . "/bin/xml-rpc-serv.cgi";
	debug_print("SendHandshake::send: $dest_xml_uri\n");

        ###########################################
        # Get current time;
	my $cur_time = get_timestamp();

        ###########################################
        #DH key generation
	my $mydh = Crypt::DH->new;
        #RFC 2412 - The OAKLEY Key Determination Protocol
        #Group 1:  A 768 bit prime
        my $DH_g="2";
        my $DH_p="1552518092300708935130918131258481755631334049434514313202351194902966239949102107258669453876591642442910007680288864229150803718918046342632727613031282983744380820890196288509170691316593175367469551763119843371637221007210577919";
	$mydh->g($DH_g);
	$mydh->p($DH_p);

        #Step (1):  create my public_key
	$mydh->generate_keys;
	my $my_DH_pub_key_str = $mydh->pub_key->bstr;
	my $my_DH_pri_key_str = $mydh->priv_key->bstr;

	debug_print("SendHandshake::send: pri_key = $my_DH_pri_key_str [" . length($my_DH_pri_key_str) . "]digits");
	debug_print("SendHandshake::send: pub_key = $my_DH_pub_key_str [" . length($my_DH_pub_key_str) . "]digits");


        ###########################################
        # Send HandShake to the URL
        ###########################################
	my $ret="";
	try{
	    $ret = send_HandShake(dest_uri =>  $dest_xml_uri, 
				  timestamp => $cur_time,
				  my_nickname =>  $af->{user__nickname},
				  my_AFID  =>  $af->{site__web_root},
				  DH_pub_key_str => $my_DH_pub_key_str,
				  mesg => $my_mesg);
	}catch Affelio::exception::NetworkException with{
	    my $E = shift;
	    throw Affelio::exception::CommunicationException($E);
	}catch Affelio::exception::Exception with{
	    my $E = shift;
	    throw Affelio::exception::CommunicationException($E);
	};
	if($ret->{flerror} == 1){
	    #XML-RPC communication was successful. 
	    #But the peer returned error. denyetc...
	    throw Affelio::exception::CommunicationException($@);
	}

        ###########################################
        # Save peer's info into pending_DB
        ###########################################
	my $tmpdb= new Affelio::SNS::Handshaker_tmpDB($af);
	$tmpdb->add_sent_Handshake($cur_time,
				   $dest_xml_uri,
				   "",
				   $cur_time,
				   $my_DH_pri_key_str);
	debug_print("SendHandshake::send: wrote DB $dest_uri => $cur_time\n");

	$output_ref->{target_url} = $dest_uri;
	$output_ref->{mypage_url} = "$af->{site__web_root}/admin.cgi";
	
	return;
    }

}
1;
