# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: MyStatus.pm,v 1.3 2005/07/01 02:00:07 slash5234 Exp $

package Affelio::App::Admin::MyStatus;
{
    use strict;

    use lib("../../../../extlib/");
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::WebInput qw(delete_HTML);

    use Exporter;
    @Affelio::App::Admin::MyStatus::ISA = "Exporter";
    @Affelio::App::Admin::MyStatus::EXPORT = qw (post);

    #######################################################################
    #post
    #######################################################################    
    sub post{
	my $af = shift;
	my $currentstatus = shift;

	debug_print("MyStatus::post start [$currentstatus]");

	$af->{user__currentstatus} = $currentstatus;

	$af->{pm}->save_profile();

	debug_print("MyStatus::post end");
    }


}
1;
