# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: ManageGroup.pm,v 1.3 2005/07/01 02:00:07 slash5234 Exp $

package Affelio::App::Admin::ManageGroup;
{
    use strict;

    use lib("../../../../extlib/");
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::MyCrypt qw( msg_encrypt url_encode);

    use Exporter;
    @Affelio::App::Admin::ManageGroup::ISA = "Exporter";
    @Affelio::App::Admin::ManageGroup::EXPORT = qw (manage_top rename_group  add_group remove_group);

    #####################################################################
    #rename_group
    #####################################################################
    sub rename_group{
	my $af = shift;                 #arg(1) AF
	my $gid = shift;                #arg(2) gid
	my $new_name = shift;           #arg(3) new_name

	$af->{gm}->rename_group($gid,$new_name);
    }

    #####################################################################
    #add_group
    #####################################################################
    sub add_group{
	my $af = shift;                 #arg(1) AF
	my $group_name = shift;         #arg(2) new_name

	if($group_name eq ""){
	    return;
	}

	debug_print("ManageGroup:add_group start.[$group_name]");

	#Create a new group
	my $gid = $af->{gm}->add_group($group_name);

	#Get attribute table
	my $attributes = $af->{pm}->get_attribute_table();
	#Set values
	my @g_perm=();
	while(my ($attr_id, $attr_name, $attr_type) 
	      = $attributes->fetchrow_array){
	    $g_perm[$attr_id] = 0;
	}
	$g_perm[1] = 0;

	debug_print("ManageGroup:add_group newg group=[@g_perm]");
	$af->{perm}->add_permission("g", $gid, \@g_perm);
    }

    #####################################################################
    #remove_group
    #####################################################################
    sub remove_group{
	my $af = shift;          #arg(1) AF
	my $gid = shift;         #arg(2) gid
	my $q = shift;           #arg(3) CGI

	$af->{gm}->remove_group($gid);
    }


    #####################################################################
    #manage_top
    #####################################################################
    sub manage_top{
	my $af = shift;                 #arg(1) AF
	my $output_ref = shift;         #arg(2) ref of %output_data; 

	my @friends_list=();
	my $result = $af->{gm}->get_all_group_list();

	while( my @row = $result->fetchrow_array ){

	    my $group_attr_URL = 'admin.cgi?mode=access_control';
	    my $group_member_URL = 'admin.cgi?mode=group_member_table';
	    my $removelink_URL = 'admin.cgi?mode=manage_groups&mode2=remove_group&gid=' . $row[0];
	    my $rename_URL = 'admin.cgi?mode=manage_groups&mode2=rename&gid=' . $row[0];

	    push(@friends_list, {group_name      => $row[1],
				 rename_URL      => $rename_URL,
				 group_attr_URL  => $group_attr_URL,
				 group_member_URL  => $group_member_URL,
				 removelink_URL  => $removelink_URL,
#				 tmpl_path     => $output_ref->{tmpl_path}
			     });
	}

	$output_ref->{"friends"} = \@friends_list;
    }


}#package
1;
