# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: FriendsGraph.pm,v 1.7 2005/07/01 02:00:07 slash5234 Exp $

package Affelio::App::Admin::FriendsGraph;
{
    use strict;

    use lib("../../../../extlib/");
    use Error qw(:try);
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::SNS::Handshaker_c;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::exception::IOException;
    use Affelio::exception::DBException;

    use Exporter;
    @Affelio::App::Admin::FriendsGraph::ISA = "Exporter";
    @Affelio::App::Admin::FriendsGraph::EXPORT = qw (show_friendsgraph retrieve);


    #######################################################################
    #retrieve
    #######################################################################    
    sub retrieve{
	my $af = shift;

	my @friends_list=();
	my $result = $af->{fm}->get_all_friend_list();
	my %tmp_hash;

	while( my @row = $result->fetchrow_array ){
	    $tmp_hash{$row[1]} = $row[7];
	}
	undef($result);

	while (my ($peer_af_id, $last_updated) = each(%tmp_hash)) {
	    debug_print("FriendsGraph::retrieve: [$peer_af_id]");

            ##################################################
            #Get peer's friends list.
	    try{
		my $ret = get_F2List(dest_uri =>"$peer_af_id/bin/xml-rpc-serv.cgi",
				     timestamp => $last_updated);
		debug_print("FriendsGraph::retrieve: \tget_F2List finished.");
		debug_print("FriendsGraph::retrieve: \t[$ret]");
		
		##################################################
		#Save the F2 list into my DB
		$af->{fm}->save_F2List($ret, $peer_af_id);
		
	    }catch Affelio::exception::IOException with{

	    };
	    

	}

    }
	


    #######################################################################
    #show_friendsgraph
    #######################################################################    
    sub show_friendsgraph{
	my $af = shift;
	my $output_data_ref = shift;

	my $ret="";

	my $f1_result= $af->{fm}->get_all_friend_list();
	my @person=();
	while(@person = $f1_result->fetchrow_array) {
	    # $person[0] uid
	    # $person[2] nickname
	    # $person[8] f2list

	    $ret .= $af->{user__nickname} . "-" . $person[2] . ",";
	    
	    my @f2list_elements = split(',', $person[8]);
	    foreach my $f2_uid (@f2list_elements){
		if($f2_uid ne ""){
		    if($f2_uid > 0){
			#The other peer is also an F1 person.
			my $f2_nickname
			    = $af->{fm}->get_attribute_by_uid($f2_uid,
							      "nickname");
			$ret .= $person[2] . "-" . $f2_nickname . ",";
		    }else{
			#The other peer is an F2 person.
			my $f2_nickname
			    = $af->{fm}->F2_get_attribute_by_uid($f2_uid,
								 "nickname");
			$ret .= $person[2] . "-" . $f2_nickname . ",";
		    }
		}
	    }
	}

	debug_print("show_FriendsGraph: edge=[$ret]");
	$$output_data_ref{edges} = $ret;
    }


}
1;
