# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: EditTemplates.pm,v 1.8 2005/07/01 02:00:07 slash5234 Exp $

package Affelio::App::Admin::EditTemplates;
{
    use strict;

    use lib("../../../../extlib/");
    use lib("../../../");
    use Fcntl;
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::WebInput;

    use Exporter;
    @Affelio::App::Admin::EditTemplates::ISA = "Exporter";
    @Affelio::App::Admin::EditTemplates::EXPORT = qw (rebuild show_templates save_templates);

    #######################################################################
    #save_templates
    #######################################################################    
    sub save_templates{
	my $af = shift;
	my $cgi = shift;

	sysopen(OUT, "$af->{site__user_dir}/af_templates/header.aftmpl", O_WRONLY|O_TRUNC);
	print OUT $cgi->param("header.aftmpl");
	close(OUT);

	sysopen(OUT, "$af->{site__user_dir}/af_templates/footer.aftmpl", O_WRONLY|O_TRUNC);
	print OUT $cgi->param("footer.aftmpl");
	close(OUT);

	sysopen(OUT, "$af->{site__user_dir}/af_templates/right.aftmpl", O_WRONLY|O_TRUNC);
	print OUT $cgi->param("right.aftmpl");
	close(OUT);

	sysopen(OUT, "$af->{site__user_dir}/af_templates/left.aftmpl", O_WRONLY|O_TRUNC);
	print OUT $cgi->param("left.aftmpl");
	close(OUT);

	sysopen(OUT, "$af->{site__user_dir}/af_templates/body_index.aftmpl", O_WRONLY|O_TRUNC);
	print OUT $cgi->param("body_index.aftmpl");
	close(OUT);

	sysopen(OUT, "$af->{site__user_dir}/af_templates/body_flist.aftmpl", O_WRONLY|O_TRUNC);
	print OUT $cgi->param("body_flist.aftmpl");
	close(OUT);

	sysopen(OUT, "$af->{site__user_dir}/af_templates/body_profile.aftmpl", O_WRONLY|O_TRUNC);
	print OUT $cgi->param("body_profile.aftmpl");
	close(OUT);
    }


    #######################################################################
    #rebuild
    #######################################################################    
    sub rebuild{
	my $af = shift;
	my $output_data_ref = shift;

	my $wi = new Affelio::misc::WebInput;

	debug_print("rebuild: start.");

	################################
	#Prep

	#Open the header template file in userdata dir
	my $header="";
	sysopen(HEADER, "$af->{site__user_dir}/af_templates/header.aftmpl", O_RDONLY);
	while(<HEADER>){$header .=$_;}
	close(HEADER);

	#Open the left template file in userdata dir
	my $left="";
	sysopen(LEFT, "$af->{site__user_dir}/af_templates/left.aftmpl", O_RDONLY);
	while(<LEFT>){$left .=$_;}
	close(LEFT);

	#Open the right template file in userdata dir
	my $right="";
	sysopen(RIGHT, "$af->{site__user_dir}/af_templates/right.aftmpl", O_RDONLY);
	while(<RIGHT>){$right .=$_;}
	close(RIGHT);

	#Open the footer template file in userdata dir
	my $footer="";
	sysopen(FOOTER, "$af->{site__user_dir}/af_templates/footer.aftmpl", O_RDONLY);
	while(<FOOTER>){$footer .=$_;}
	close(FOOTER);


	################################
	#Main loop.  For each body template....
	my $from_template_file = "";
	opendir(DIR1, "$af->{site__user_dir}/af_templates");
	while (defined($from_template_file = readdir(DIR1))) {

	    $from_template_file = $wi->PTN_basefilename($from_template_file);

	    if($from_template_file =~ /\.aftmpl/){

		debug_print("rebuild: Source file=[$from_template_file]");

		my $from_contents="";
		sysopen(BODY, "$af->{site__user_dir}/af_templates/$from_template_file", O_RDONLY);
		while(<BODY>){$from_contents .=$_;}
		close(BODY);

		my $template_name = $from_template_file;
		$template_name =~ s/\.aftmpl//g;
		if($from_template_file =~ /body.*\.aftmpl/){
		    #Body template files....
		    $template_name =~ s/body_//g;
		}else{
		    $template_name = "_" . $template_name;
		}		    
		
		my $output_contents ="";
		if($from_template_file =~ /body.*\.aftmpl/){
		    #Concatenate 3 files.
		    $output_contents = $header . $left 
			. $from_contents . $right . $footer;
		}else{
		    $output_contents = $from_contents;
		}

		###################################################
		#Replacement
		###################################################
		#  (1)s/AF_VAR/TMPL_VAR/g
		$output_contents =~ s/AF_VAR/TMPL_VAR/g;

		#  (2)AF_BLOCK
		my $aftag_file;
		opendir(DIR2, "$af->{site__fs_root}/lib/Affelio/App/Admin/AFTemplateBlocks");
		while (defined($aftag_file = readdir(DIR2))) {
		    #print "$aftag_file;
		    if(($aftag_file ne '.') && ($aftag_file ne '..') 
		       && ($aftag_file ne 'CVS')){
			
			debug_print("rebuild:\taf_tag file = $aftag_file");
			my $tagname = $aftag_file;
			$tagname =~s/\.aftag//g;
			#debug_print("rebuild: Replace AF_BLOCK=$tagname");
			my $tagcontent="";
			open(TAGCONTENT, 
			     "$af->{site__fs_root}/lib/Affelio/App/Admin/AFTemplateBlocks/$aftag_file");
			while(<TAGCONTENT>){$tagcontent .=$_;}
			close(TAGCONTENT);
			
			my $rep = '<AF_BLOCK NAME="' . $tagname . '">';
			$output_contents =~ s/$rep/$tagcontent/g;
		    }#if
		}#while

		###################################################
		#Save to file in templates_dyn/ dir
		###################################################
		sysopen(OUT, "$af->{site__fs_root}/templates_dyn/$template_name.tmpl", O_WRONLY|O_CREAT|O_TRUNC, 0755);
		print OUT $output_contents;
		close(OUT);
		
	    }#if
	}#while(for each file...)

	$ENV{PATH} = "/bin:/usr/bin";

	debug_print("rebuild: header+left => Header"); 
	system("cat $af->{site__fs_root}/templates_dyn/_header.tmpl  $af->{site__fs_root}/templates_dyn/_left.tmpl > $af->{site__fs_root}/templates_dyn/Header.tmpl");
	debug_print("rebuild: right+footer => Footer"); 
	system("cat $af->{site__fs_root}/templates_dyn/_right.tmpl  $af->{site__fs_root}/templates_dyn/_footer.tmpl > $af->{site__fs_root}/templates_dyn/Footer.tmpl");

	debug_print("rebuild: end.");
    }

    #######################################################################
    #show_templates
    #######################################################################    
    sub show_templates{
	
	my $af = shift;
	my $output_ref = shift;

	my $body="";
	sysopen(IN, "$af->{site__user_dir}/af_templates/header.aftmpl", O_RDONLY);
	while(<IN>){$body .=$_;}
	close(IN);
	$output_ref->{'header_template'} = $body;

	$body="";
	sysopen(IN, "$af->{site__user_dir}/af_templates/footer.aftmpl", O_RDONLY);
	while(<IN>){$body .=$_;}
	close(IN);
	$output_ref->{'footer_template'} = $body;

	$body="";
	sysopen(IN, "$af->{site__user_dir}/af_templates/left.aftmpl", O_RDONLY);
	while(<IN>){$body .=$_;}
	close(IN);
	$output_ref->{'left_template'} = $body;

	$body="";
	sysopen(IN, "$af->{site__user_dir}/af_templates/right.aftmpl", O_RDONLY);
	while(<IN>){$body .=$_;}
	close(IN);
	$output_ref->{'right_template'} = $body;

	$body="";
	sysopen(IN, "$af->{site__user_dir}/af_templates/body_index.aftmpl", O_RDONLY);
	while(<IN>){$body .=$_;}
	close(IN);
	$output_ref->{'body_template__index'} = $body;

	$body="";
	sysopen(IN, "$af->{site__user_dir}/af_templates/body_flist.aftmpl", O_RDONLY);
	while(<IN>){$body .=$_;}
	close(IN);
	$output_ref->{'body_template__flist'} = $body;

	$body="";
	sysopen(IN, "$af->{site__user_dir}/af_templates/body_profile.aftmpl", O_RDONLY);
	while(<IN>){$body .=$_;}
	close(IN);
	$output_ref->{'body_template__profile'} = $body;
	
    }

}
1;
