# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: EditProfile.pm,v 1.3 2005/07/01 02:00:07 slash5234 Exp $

package Affelio::App::Admin::EditProfile;
{
    use strict;

    use lib("../../../../extlib/");
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::MyCrypt qw( msg_encrypt url_encode);

    use Exporter;
    @Affelio::App::Admin::EditProfile::ISA = "Exporter";
    @Affelio::App::Admin::EditProfile::EXPORT = qw (show_profileeditor  show_profile save_profile);


    #######################################################################
    #set_profile_into_hash__show
    #######################################################################    
    sub set_profile_into_hash__show{
	my $self = shift;
	my $af = $self->{af};
	my $output_data_ref = shift;
	my $viewers_mode = shift;
	debug_print("set_profile_into_hash__show: start mode=[$viewers_mode]");

	foreach my $key (sort keys %$af){
	    #debug_print("set_profile_into_hash: " . $key . "=" . $af->{$key});
	    
	    if($key =~ /user__mode_/){
		my $key2 = $key;
		$key2 =~ s/user__mode_//;
		
		if(  (($af->{$key} eq "na") 
		      && ($viewers_mode eq "self"))
		     ||
		     (($af->{$key} eq "f1") 
		      && (($viewers_mode eq "self") 
			  || ($viewers_mode eq "f1"))
		      )
		     ||
		     (($af->{$key} eq "f2") 
		      && (($viewers_mode eq "self") 
			  || ($viewers_mode eq "f1") 
			  || ($viewers_mode eq "f2")) 
		      )
		     ||
		     ($af->{$key} eq "pb") 
		     ){
		    
		    my $key3 = "flg_$key2";
		    $$output_data_ref{$key3} = "true";
		    debug_print("af($key3) = $$output_data_ref{$key3}");
		}
		
	    }elsif($key =~ /user__/){
		my $key2 = $key;
		$key2 =~ s/user__//;
		$$output_data_ref{$key2} = $af->{$key};
		debug_print("af($key2) = $af->{$key}");
	    }
	} 
    }

    #######################################################################
    #show_profileeditor
    #######################################################################    
    sub show_profileeditor{
	my $af = shift;
	my $output_data_ref = shift;
	
	foreach my $key (sort keys %$af){
	    #debug_print("set_profile_into_hash: " . $key . "=" . $af->{$key});
	    
	    if($key =~ /user__mode_/){
		
	    }elsif($key =~ /user__/){
		my $key2 = $key;
		$key2 =~ s/user__//;
		$$output_data_ref{$key2} = $af->{$key};
		debug_print("af($key2) = $af->{$key}");
	    }
	} 
    }

    #######################################################################
    #save_profile
    #######################################################################
    sub save_profile{
	my $af = shift;
	my $cgi =shift;
	my $err="";
	
	my @param_names = $cgi->param;

	foreach my $param_key (@param_names){
	    if($param_key ne "submit"){
		$af->{"user__$param_key"} 
		= $cgi->param($param_key);
#		= Jcode->new($cgi->param($param_key), 

		debug_print("EditProfile::save_profile: $param_key= " . Jcode::getcode($cgi->param($param_key)) . "\n");
		debug_print("EditProfile::save_profile: $param_key= [". $af->{"user__$param_key"} . "]");

	    }
	} 
	
	#XXX 
	#Sanitize inputs
	
	#XXX
	#Semantics check
	$err .= check_nickname( $af->{user__nickname} );
	#$err .=  ...

	#Save Profile
	$af->{pm}->save_profile();

	return($err);
    }


    #########################################################################
    # Misc routines.
    # XXX  : need to be relocated.
    #########################################################################
    sub check_nickname{
	my $input = shift;

	if($input =~ /[^\w]/){
	    return "nickname can be only alphabet characters.";
	}else{
	    return "";
	}
    }

}
1;
