# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: Configuration.pm,v 1.3 2005/07/01 02:00:07 slash5234 Exp $

package Affelio::App::Admin::Configuration;
{
    use strict;

    use lib("../../../../extlib/");
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::Encoding qw(db_encode db_decode);
    use Affelio::misc::Time qw(timestamp2string);
    use Affelio::misc::WebInput;

    use Exporter;
    @Affelio::App::Admin::Configuration::ISA = "Exporter";
    @Affelio::App::Admin::Configuration::EXPORT = qw (show configure);

    #######################################################################
    #configure
    #######################################################################    
    sub configure{
	my $af= shift;
	my $cgi = shift;

	debug_print("Config::conf: start.");
	my $wi = new Affelio::misc::WebInput;
	
	##############################################
	#Top page
	##############################################
	my $toppage = $wi->PTN_word($cgi->param("toppage"));
	$af->{userpref__toppage_app_installname} = $toppage;
	debug_print("Config::conf: toppage=[$toppage]");

	##############################################
	#Messaging
	##############################################
	my $val = $wi->PTN_word($cgi->param("pref__mesging__emailflg"));
	debug_print("Config::conf: mesging__emailflg=[$val]");
	if($val eq "no"){
	    $af->{userpref__mesging__emailflg} = "no";	    
	}else{
	    $af->{userpref__mesging__emailflg} = "yes";	    
	}

	##############################################
	#Preferred Hosting Service
	##############################################
	$af->{userpref__preferred_hosting_service} =
	    $wi->PTN_URL($cgi->param("pref__hosting_service"));

	$af->write_user_prefs();
	debug_print("Config::conf: end.");
    }



    #######################################################################
    #show
    #######################################################################    
    sub show{
	my $af= shift;
	my $output_ref = shift;

	debug_print("Config::show start.");

	##############################################
	#Top Page
	##############################################
	my @applications=();
	my $install_name;
	my $app;
	my $core_flag="";
	my $app_flag="";

	$output_ref->{"applications"} = \@applications;
	if($af->{userpref__toppage_app_installname} eq "Affelio"){
	    $core_flag="true";
	}
	###############
	#Core
	###############
	push(@applications, {install_title => "Affelio Core",
			     install_name => "Affelio",
			     selected => $core_flag}    );
	###############
	#Apps
	###############
	while (($install_name, $app) = each(%{$af->{am}->{apps}})){
	    
	    if($af->{userpref__toppage_app_installname} 
	       eq $app->{install_name}){
		$app_flag="true";
	    }else{
		$app_flag="";
	    }

	    push(@applications, {install_title => "(Application) " . 
				     $app->{install_title},
				 install_name => $app->{install_name},
				 selected => $app_flag}
		 );
	}

	##############################################
	#Messaging
	##############################################
	my $name = "pref__mesging_emailflg__" 
	    . $af->{userpref__mesging__emailflg};
	$output_ref->{$name} = "checked";

	##############################################
	#Preferred Hosting Service
	##############################################
	$output_ref->{"pref__hosting_service"} = 
	    $af->{userpref__preferred_hosting_service};

	debug_print("Config::show end.");
    }


}
1;
