# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: AccessLog.pm,v 1.9 2005/07/03 09:15:30 slash5234 Exp $

package Affelio::App::Admin::AccessLog;
{
    use strict;

    use lib("../../../../extlib/");
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::Encoding qw(db_encode db_decode);
    use Affelio::misc::Time;
    use Affelio::misc::WebInput;

    use Exporter;
    @Affelio::App::Admin::AccessLog::ISA = "Exporter";
    @Affelio::App::Admin::AccessLog::EXPORT = qw (show);


    #######################################################################
    #show
    #######################################################################    
    sub show{
	my $af= shift;
	my $q=shift;
	my $output_ref = shift;
	my $wi = new Affelio::misc::WebInput;

	debug_print("AccessLog::show start.");

	my @access_log=();
	$output_ref->{"access_log"} = \@access_log;

	###############################
	#start and end time
	###############################
	#my $start_time = get_today();
	my $start_time = "20050620000000";
	my $cur_time = get_timestamp();

	###############################
	#Today's date
	###############################
	#my $t_year = substr ($start_time, 0, 4);
	#my $t_mon  = substr ($start_time, 4, 2);
	#my $t_mday = substr ($start_time, 6, 2);
	#$output_ref->{"log_date"} = "$t_year/$t_mon/$t_mday";

	###############################
	#Access to AccessLog Manager
	###############################
	my $result = $af->{alm}->get_log($start_time, $cur_time);

	###############################
	#Parse result
	###############################
	while( my ($id, $id2, $time, $nickname, $afid, $type) = $result->fetchrow_array ){

	    my $true_name;
	    if($afid =~ /^http:\/\//){
		##########
		#Friend!
		##########
		$true_name = '<A HREF="' . $af->{site__web_root} . "/outgoing.cgi?dest_url=" . $afid . '" target="_blank">' . $nickname . '</A>';
	    }else{
		##########
		#Anonymous
		#afid = remote host
		##########
		my $len = length($afid);
		if($len > 20){
		    $true_name = '<SPAN TITLE="' . $afid . '">...' . substr($afid, $len-20, 20) . '</SPAN>';
		}else{
		    $true_name = $afid;
		}
	    }

	    if($id2 ==0 ){ $id2="";} 

	    my $true_type; 
	    if($type eq "pb") {$true_type='<AF_M text="_VISITOR_TYPE_PB">';}
	    if($type eq "f2") {$true_type='<AF_M text="_VISITOR_TYPE_F2">';}
	    if($type eq "f1") {$true_type='<AF_M text="_VISITOR_TYPE_F1">';}
	    if($type eq "self") {$true_type='<AF_M text="_VISITOR_TYPE_SELF">';}
	    push(@access_log, {id=> $id,
			       id2=> $id2,
			       time=> timestamp2stringB($time),
			       nickname => $true_name,
			       type => $true_type});
	}

	debug_print("AccessLog::show end.");
    }


}
1;
