# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: AccessControl.pm,v 1.3 2005/07/01 02:00:07 slash5234 Exp $

package Affelio::App::Admin::AccessControl;
{
    use strict;

    use lib("../../../../extlib/");
    use lib("../../../../lib/");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::MyCrypt qw( msg_encrypt url_encode);

    use Exporter;
    @Affelio::App::Admin::AccessControl::ISA = "Exporter";
    @Affelio::App::Admin::AccessControl::EXPORT = qw (show_GroupAttribute_table  save_GroupAttribute_table);

    #####################################################################
    #save_GroupAttribute_table
    #####################################################################
    sub save_GroupAttribute_table{
	my $af = shift;                 #arg(1) AF
	my $q  = shift;                 #arg(2) CGI

	my @params = $q->param;
	foreach my  $i (@params){
	    debug_print("save_GroupAttribute_tbl: [$i] =". $q->param($i));
	}

	#######################################################
	# Save F1, F2, and PB
	{
	    my @gids = ("f1", "f2", "pb");
	    my @group_names = ($af->{lh}->maketext("_VISITOR_TYPE_F1"),
			       $af->{lh}->maketext("_VISITOR_TYPE_F2"),
			       $af->{lh}->maketext("_VISITOR_TYPE_PB"));
	    my @option_pids = (1,2,3);

	    for(my $i=0; $i<3; $i++){
		my $gid = $gids[$i];
		my $group_name = $group_names[$i];
		my $option_pid = $option_pids[$i];

		debug_print("save_GroupAttribute_table: For group[$gid]...");

		#Get attribute table
		my $attributes = $af->{pm}->get_attribute_table();

		#Set values
		my @g_perm=();
		while(my ($attr_id, $attr_name, $attr_type) 
		      = $attributes->fetchrow_array){
		    if($q->param("f__" . $gid . "__" . $attr_name) eq "on"){
			$g_perm[$attr_id] = 1;
		    }else{
			$g_perm[$attr_id] = 0;
		    }
		}
		$g_perm[0] = 1;
		debug_print("save_GroupAttribute_table: group_permission=[@g_perm]");
		$af->{perm}->update_permission($option_pid, \@g_perm);

	    } #while
	}#part


	#######################################################
	# Save registered groups
	{
	    my $groups_SQL = $af->{gm}->get_all_group_list();

	    #For each group returned...
	    while( (my ($gid, $group_name, $members, $option_pid) 
		    = $groups_SQL->fetchrow_array)){
		
		debug_print("save_GroupAttribute_table: For group[$gid] (pid=$option_pid)...");
		if($gid <1){last;}

		#Get attribute table
		my $attributes = $af->{pm}->get_attribute_table();

		#Set values
		my @g_perm=();
		while(my ($attr_id, $attr_name, $attr_type) 
		      = $attributes->fetchrow_array){
		    if($q->param("g__" . $gid . "__" . $attr_name) eq "on"){
			$g_perm[$attr_id] = 1;
		    }else{
			$g_perm[$attr_id] = 0;
		    }
		}
		$g_perm[0] = 1;
		debug_print("save_GroupAttribute_table: group_permission=[@g_perm]");
		$af->{perm}->update_permission($option_pid, \@g_perm);
		
	    }#while
	}#part

	#######################################################
	# Save newly added group
	{
	    if($q->param("newg_group_name") ne ""){
		
		my $gid = $af->{gm}->add_group($q->param("newg_group_name"));

		#Get attribute table
		my $attributes = $af->{pm}->get_attribute_table();

		#Set values
		my @g_perm=();
		while(my ($attr_id, $attr_name, $attr_type) 
		      = $attributes->fetchrow_array){
		    if($q->param("newg_" . $attr_name) eq "on"){
			$g_perm[$attr_id] = 1;
		    }else{
			$g_perm[$attr_id] = 0;
		    }
		}
		$g_perm[1] = 1;
		debug_print("save_GroupAttribute_table: newg group=[@g_perm]");
		$af->{perm}->add_permission("g", $gid, \@g_perm);

	    }
	}
    }		


    #####################################################################
    #show_GroupAttribute_table
    #####################################################################
    sub show_GroupAttribute_table{
	my $af = shift;                 #arg(1) AF
	my $output_ref = shift;         #arg(3) ref of %output_data; 
	
	debug_print("show_GroupAttribute_table:  start.");
	my @groups_ret1=();
	my @groups_ret2=();

	#######################################################
	# F1, F2, and PB
	{
	    my @gids = ("f1", "f2", "pb");
	    my @group_names = ($af->{lh}->maketext("_VISITOR_TYPE_F1"),
			       $af->{lh}->maketext("_VISITOR_TYPE_F2"),
			       $af->{lh}->maketext("_VISITOR_TYPE_PB"));
	    my @option_pids = (1,2,3);

	    for(my $i=0; $i<3; $i++){
		my $gid = $gids[$i];
		my $group_name = $group_names[$i];
		my $option_pid = $option_pids[$i];

		debug_print("show_GroupAttribute_table: For group[$gid]...");

		#set group_name
		my %this_group_ret =();
		$this_group_ret{"group_name"} = $group_name;

		#For each group, get the permission list.
		my $g_perm_result = $af->{perm}->get_permission("f", "$gid");
		my @g_perm = $g_perm_result->fetchrow_array;
		debug_print("show_GroupAttribute_table: group_permission=[@g_perm]");
		#Get attribute table
		my $attributes = $af->{pm}->get_attribute_table();

		#Set values
		while(my ($attr_id, $attr_name, $attr_type) 
		      = $attributes->fetchrow_array){

		    debug_print("show_GroupAttribute_table: attr_id=$attr_id ($attr_name)");
		    
			$this_group_ret{"chkbox_id__" . $attr_name} 
			= "f__" . $gid . "__" . $attr_name;
			
			if($g_perm[$attr_id+3] >= 1){
			    $this_group_ret{"chkbox_chkd_flg__" . $attr_name} 
			    ="checked";
			}else{
			    $this_group_ret{"chkbox_chkd_flg__" . $attr_name} 
			    ="";
			}
		}

		push(@groups_ret1, \%this_group_ret);


	    } #while

	}#part


	#######################################################
	# Registered Groups
	my $groups_SQL = $af->{gm}->get_all_group_list();

	#For each group returned...
	while( (my ($gid, $group_name, $members, $option_pid) 
		= $groups_SQL->fetchrow_array)){

	    debug_print("show_GroupAttribute_table: For group[$gid]...");

	    if($gid <1){last;}

	    #set group_name
	    my %this_group_ret =();
	    $this_group_ret{"group_name"} = $group_name;

	    #For each group, get the permission list.
	    my $g_perm_result = $af->{perm}->get_permission("g", "$gid");
	    my @g_perm = $g_perm_result->fetchrow_array;
	    debug_print("show_GroupAttribute_table: group_permission=[@g_perm]");
	    #Get attribute table
	    my $attributes = $af->{pm}->get_attribute_table();

	    #Set values
	    while(my ($attr_id, $attr_name, $attr_type) 
		  = $attributes->fetchrow_array){

		$this_group_ret{"chkbox_id__" . $attr_name} 
		= "g__" . $gid . "__" . $attr_name;

		if($g_perm[$attr_id+3] >= 1){
		    $this_group_ret{"chkbox_chkd_flg__" . $attr_name} 
		    ="checked";
		}else{
		    $this_group_ret{"chkbox_chkd_flg__" . $attr_name} 
		    ="";
		}
	    }

	    push(@groups_ret2, \%this_group_ret);
	}#while

	$output_ref->{"groups1"} = \@groups_ret1;
	$output_ref->{"groups2"} = \@groups_ret2;

    }


}#package
1;
