#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: index.cgi,v 1.13 2005/07/03 13:20:06 slash5234 Exp $

use strict;

use lib("./extlib");
use CGI qw(-unique_headers);
$CGI::DISABLE_UPLOADS = 1;
$CGI::POST_MAX = 102_400;
use CGI::Session qw(-ip_match);
use HTML::Template;
use Error qw(:try);

use lib("./lib");
use Affelio;
use Affelio::misc::CGIError;
use Affelio::misc::Debug qw(debug_print);
use Affelio::misc::NetMisc;
use Affelio::misc::Time;
use Affelio::misc::WebInput;
use Affelio::SNS::Handshaker_c;

debug_print("index.cgi: start.");
my $q = new CGI;

############################################################################
#Load Affelio
############################################################################
my $wi = new Affelio::misc::WebInput(); 
my $cfg_dir = "./";
my $af;
try{
    $af = new Affelio(ConfigDir => $cfg_dir);
}catch Error with{
    my $e = shift;
    error($q, "Affelio load error.\n" . $e);
};

############################################################################
#Check session w/ cookie
############################################################################
my $sid = $q->cookie("affelio-$af->{user__nickname}");
debug_print("index.cgi: sid from cookie = $sid");
my $session;
if($sid){
    $session = new CGI::Session(undef, 
				$sid, 
				{Directory=> $af->{site__session_dir}});
}

my $visitor_type="pb";
my $visitor_nickname="anonymous";
my $visitor_afid="";

if($session){
    $visitor_type 
	= $wi->PTN_visitor_type($session->param("type"));
    $visitor_nickname 
	= $wi->PTN_nickname($session->param("user_nickname"));

    $visitor_afid 
	= $wi->PTN_URL($session->param("user_afid"));
}
if($visitor_type eq ""){
    $visitor_type="pb";
    $visitor_nickname="anonymous";
}
debug_print("index.cgi: visitor_type=      $visitor_type");
debug_print("index.cgi: visitor_nickname=  $visitor_nickname");
debug_print("index.cgi: visitor_afid=      $visitor_afid");


############################################################################
#Main
############################################################################
my %output_data = ();
my $TMPL_FILE ="";

######################################################
#Template file
######################################################
my $mode = $wi->PTN_mode($q->url_param("mode"));
debug_print("================$mode");

if(($mode eq "") ||  !defined($mode)){
    #If "mode" is not set, we will look at $self->{userpref__toppage_app_path}
    #value. 
    my $abs_next_URL = $af->{site__web_root} . "/" . $af->{userpref__toppage_app_path};

    print "Location: $abs_next_URL", "\n\n";    
    exit(1);
}
$TMPL_FILE = "$af->{site__fs_root}/templates_dyn/"  . $mode . ".tmpl";


######################################################
#Data prep (1)
######################################################

#################
#Site info
#################
$output_data{"site__web_root"} = $af->{site__web_root};
$output_data{"site__skin_dir"} = $af->{site__web_root} . "/skins/" . $af->{userpref__skin};
$output_data{"site__locale"} = $af->{site__locale};

try{
    $af->get_module_list(\%output_data, $visitor_afid, $visitor_type);
    $af->get_guest_owner_list(\%output_data);
}catch Error with{
    my $e = shift;
    error($q, "Affelio init error.\n" . $e);
};


#################
#Client info
#################
$output_data{'client_afid'}= $visitor_afid;
#
my $relation;
if($visitor_type eq "self"){
    $relation = $af->{lh}->maketext("_VISITOR_TYPE_SELF");
}elsif($visitor_type eq "f1"){
    $relation = $af->{lh}->maketext("_VISITOR_TYPE_F1");
}elsif($visitor_type eq "f2"){
    $relation = $af->{lh}->maketext("_VISITOR_TYPE_F2");
}else{
    $relation = $af->{lh}->maketext("_VISITOR_TYPE_PB");
}
$output_data{'client_relationship'}= $relation;

$output_data{'client_type'}= $visitor_type;
$output_data{'client_nickname'}= $visitor_nickname;
$output_data{'client_type_' . $visitor_type}= "true";

#################
#Default profile info
#################
$output_data{'profile_nickname'} = $af->{user__nickname};
$output_data{"profile_intromesg1"} = $af->{user__intromesg1};
$output_data{'profile_myimage_path'} = 
    "./bin/get_content.cgi?module=core&content=/profile/profile_face.jpg";

######################################################
#Data prep from Models 
######################################################
#Inject Profile Data
use Affelio::App::ShowProfile;
try{
    Affelio::App::ShowProfile::show_profile($af,
					    \%output_data, 
					    $visitor_type,
					    $visitor_afid);
}catch Error with{
    my $e = shift;
    error($q, "Affelio: model execution  error.\n" . $e);
};

#Friendlist
use Affelio::App::FriendRoutines;
my @friendlist_5;
try{
    @friendlist_5 = get_friends_list($af, $visitor_afid, $visitor_type, 5);
}catch Error with{
    my $e = shift;
    error($q, "Affelio: model execution  error.\n" . $e);
};
$output_data{"friendlist_5"} = \@friendlist_5;

my @friendlist_5_IF;
try{
    @friendlist_5_IF = get_friends_list_IF($af,$visitor_afid, $visitor_type,5);
}catch Error with{
    my $e = shift;
    error($q, "Affelio: model execution  error.\n" . $e);
};
$output_data{"friendlist_5_IF"} = \@friendlist_5_IF;

my @friendlist_all;
try{
    @friendlist_all = get_friends_list($af, $visitor_afid, $visitor_type, -1);
}catch Error with{
    my $e = shift;
    error($q, "Affelio: model execution  error.\n" . $e);
};
$output_data{"friendlist_all"} = \@friendlist_all;

my @friendlist_all_IF;
try{
    @friendlist_all_IF=get_friends_list_IF($af,$visitor_afid,$visitor_type,-1);
}catch Error with{
    my $e = shift;
    error($q, "Affelio: model execution  error.\n" . $e);
};
$output_data{"friendlist_all_IF"} = \@friendlist_all_IF;

try{
    $output_data{"friend__F1count"} = $af->{fm}->get_F1_count();
    $output_data{"friend__F2count"} = $af->{fm}->get_F2_count();
}catch Error with{
    my $e = shift;
    error($q, "Affelio: error from FriendManager\n" . $e);
};

###########################################################################
#Inject data into template 
###########################################################################
my $tmpl;
try{
    $tmpl = new HTML::Template( filename => $TMPL_FILE,
			       die_on_bad_params => 0);
}catch Error with{
    my $e = shift;
    error($q, "Affelio: error in HTML::Template init.\n" . $e);
};

foreach my $data_key (keys(%output_data)) {
    debug_print("index.cgi: $data_key = $output_data{$data_key}");
    $tmpl->param($data_key => $output_data{$data_key});
} 

###########################################################################
#AccessLog
###########################################################################
if($visitor_type ne "self"){
    my $afid;
    if($visitor_afid eq ""){
	$afid = $q->remote_host;
    }else{
	$afid = $visitor_afid;
    }

    try{
	$af->{alm}->save_log($afid, $visitor_nickname, $visitor_type);
    }catch Error with{
	my $e = shift;
	error($q, "Affelio: error in AccessLogging\n" . $e);
    };

}

###########################################################################
#Output
###########################################################################
print "Content-type: text/html; charset=UTF-8\n";
print "Pragma: no-cache", "\n\n"; 
print $af->translate_templateL10N($tmpl->output);
