#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: incoming.cgi,v 1.7 2005/07/03 13:42:05 slash5234 Exp $

use strict;

use lib("./extlib");
use CGI qw(-unique_headers);
$CGI::DISABLE_UPLOADS = 1;
$CGI::POST_MAX = 102_400;
use CGI::Session qw(-ip_match);
use HTML::Template;
use Error qw(:try);

use lib("./lib");
use Affelio;
use Affelio::misc::CGIError;
use Affelio::misc::Debug      qw(debug_print);
use Affelio::misc::Time qw(get_timestamp get_expire_stamp);
use Affelio::misc::MyCrypt qw(msg_decrypt url_decode);
use Affelio::misc::NetMisc;
use Affelio::SNS::Handshaker_c;
use Affelio::misc::WebInput;

debug_print("incoming.cgi: start.");
my $q = new CGI;

############################################################################
#Load Affelio, CGI
############################################################################
my $cfg_dir = ".";
my $af;
try{
    $af = new Affelio(ConfigDir => $cfg_dir);
}catch Error with{
    my $e = shift;
    error($q, "Affelio load error.\n" . $e);
};
my $wi = new Affelio::misc::WebInput(); 
my $sid = $q->cookie("affelio-$af->{user__nickname}");
debug_print("incoming.cgi: sid from cookie = $sid");
my $session="";
if($sid){
    $session = new CGI::Session(undef, 
				$sid, 
				{Directory=> $af->{site__session_dir}});
}

############################################################################
#Get args
############################################################################
my $forward_id = $q->url_param("forward_id");
my $referrer = $q->param("referrer");
debug_print("incoming.cgi: forward_id      =$forward_id");

############################################################################
#Load Friend manager and get passAB
############################################################################
my $passAB;
try{
   $passAB = $af->{fm}->get_attribute_by_afid($referrer, "password");
}catch Error with{
    my $e = shift;
    error($q, "Error from FriendManager.\n" . $e);
};
debug_print("incoming.cgi: passAB=$passAB\n");
if(!defined($passAB) || $passAB eq ""){
    error($q, "Affelio: Invalid forwarding. Shared key not found!");
}


############################################################################
#Decrypt the forward_id message;
############################################################################
my ($FID_timestamp, $FID_expire, $FID_remoteip, $FID_visitorAFID, $FID_visitor_nickname, $FID_visitor_type)
    =split('\*', msg_decrypt( url_decode($forward_id), $passAB ) ); 

$FID_visitorAFID = url_decode($FID_visitorAFID);
$FID_visitor_nickname = url_decode($FID_visitor_nickname);

debug_print("incoming.cgi: timestamp      =$FID_timestamp");
debug_print("incoming.cgi: expire         =$FID_expire");
debug_print("incoming.cgi: remote_ip      =$FID_remoteip");
debug_print("incoming.cgi: visitor_afid      =$FID_visitorAFID");
debug_print("incoming.cgi: visitor_nickname  =$FID_visitor_nickname");
debug_print("incoming.cgi: visitor_type(original)      =$FID_visitor_type");

if((my $i=index($FID_visitor_type, "self"))==0){
    $FID_visitor_type = "f1";
}elsif((my $i=index($FID_visitor_type, "f1"))==0){
    $FID_visitor_type = "f2";
}else{
    $FID_visitor_type = "pb";
}
debug_print("incoming.cgi: visitor_type(decreased)     =$FID_visitor_type");


############################################################################
#Error detection
############################################################################
my $errormsg="";
if(($FID_timestamp eq "") || ($FID_remoteip eq "") || 
   ($FID_visitorAFID eq "") || ($FID_expire eq "") ||
   ($FID_visitor_type eq "") ){
    $errormsg .= "Forward_Id data is invalid! \n";
}else{
    if($FID_remoteip ne $q->remote_addr){
	$errormsg .= "Your remote IP address does not match! \n";
    }
    if($FID_expire < get_timestamp() ){
	$errormsg .= "This forward_id is too late to start. \n";
    }
}
if($errormsg){
    #error $errormsg;
    debug_print("incoming.cgi: ERROR! : $errormsg");
    debug_print("incoming.cgi: Just go to my Affelio without any cookie."); 
    print $q->redirect( -url => $af->{site__web_root});
}

############################################################################
#Check current session
############################################################################
#If a cookie is set already, check it and reuse it if we can.
my $ck_visitor_type="pb";
my $ck_visitor_nickname="anonymous";
my $ck_visitor_afid="";
if($session){
    debug_print("incoming.cgi: Found a pre-existing session!");
    $ck_visitor_type = $session->param("type");
    $ck_visitor_nickname = $session->param("user_nickname");
    $ck_visitor_afid = $session->param("user_afid");
}
debug_print("incoming.cgi: cookie visitor_type  = $ck_visitor_type");
debug_print("incoming.cgi: cookie visitor_nickname  = $ck_visitor_nickname");
debug_print("incoming.cgi: cookie visitor_afid  = $ck_visitor_afid");

if($session &&
   ( (($ck_visitor_type eq "self") && ( $FID_visitor_type ne "self") ) 
     || ( ($ck_visitor_type eq "f1") && 
	  (( $FID_visitor_type eq "f2") || ( $FID_visitor_type eq "pb") ) )
     || ( ($ck_visitor_type eq "f2") && ( $FID_visitor_type eq "pb") )
    )
   ){
    #########################
    # OK. 
    # This visitor is already authenticated as a closer visitor.
    # Use existing session.
    #########################
    debug_print("incoming.cgi: OK. You already have a cookie, and");
    debug_print("incoming.cgi: the existing session has higher right!");
    debug_print("incoming.cgi: end. Forwarding to my homepage.");
    print $q->redirect( -url => $af->{site__web_root});

}else{
    #########################
    # Startup a new session
    #########################
    debug_print("incoming.cgi: You don't have a cookie, or you have");
    debug_print("incoming.cgi: a cookie with the same or lower rights.");
    debug_print("incoming.cgi: ");
    debug_print("incoming.cgi: Let's start up a session with a cooike.");

    #lookup our friend table with FID_visitorAFID
    my $tmp1;
    try{
	$tmp1 = $af->{fm}->get_attribute_by_afid($FID_visitorAFID, "password");
    }catch Error with{
	my $e = shift;
	error($q, "Error from FriendManager.\n" . $e);
    };
    if($tmp1 ne ""){	$FID_visitor_type="f1";    }

    #Start up a sesion
    my $ss = new CGI::Session("driver:File", 
			      undef, 
			      {Directory=> $af->{site__session_dir}});
    #Set values into session
    $ss->param("user_afid", $FID_visitorAFID);
    $ss->param("user_nickname", $FID_visitor_nickname);
    $ss->param("type", $FID_visitor_type);
    #current time
    #expire time
    $ss->expire('+1h');

    debug_print("incoming.cgi: startup_session finished.\n");    

    #Retrieve a sesion_id
    my $session_id = $ss->id();
    debug_print("incoming.cgi: session_id = [$session_id]\n");

    #Prepare a cookie with the session_id
    my $cookie = $q->cookie ( -name => "affelio-$af->{user__nickname}",
			      -value => $session_id,
			      -path => URL2path($af->{site__web_root}));

    debug_print("incoming.cgi: new cookie [$session_id]\n");
    debug_print("incoming.cgi: new cookie [" . URL2domain($af->{site__web_root}) .  "]\n");
    debug_print("incoming.cgi: new cookie [" . URL2path($af->{site__web_root}) .  "]\n");
    debug_print("incoming.cgi: New session has been established.");
    debug_print("incoming.cgi: user_type:    " . $ss->param("type") );
    debug_print("incoming.cgi: user_afid:    " . $ss->param("user_afid") );
    debug_print("incoming.cgi: user_nickname:" . $ss->param("user_nickname") );

    debug_print("incoming.cgi: end. Forwarding to my homepage.");
    print $q->redirect( -url => $af->{site__web_root},
			-cookie => $cookie);
}

exit(1);
