#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: send_handshake.cgi,v 1.4 2005/07/01 01:49:01 slash5234 Exp $

use strict;
use lib("../extlib");
use CGI qw(-unique_headers);
$CGI::DISABLE_UPLOADS = 1;
$CGI::POST_MAX = 102_400;
use CGI::Session qw(-ip_match);
use HTML::Template;
use Fcntl qw( :DEFAULT :flock);
use Crypt::DH;
use Error qw(:try);

use lib("../lib");
use Affelio;
use Affelio::misc::CGIError;
use Affelio::misc::Debug;
use Affelio::misc::Time qw(get_timestamp);
use Affelio::misc::WebInput;
use Affelio::SNS::Handshaker_c;
use Affelio::SNS::Handshaker_tmpDB;
use Affelio::exception::Exception;
use Affelio::exception::IOException;

############################################################################
#Load Affelio
my $cfg_dir = "..";
my $af = new Affelio(ConfigDir => $cfg_dir);

############################################################################
#Sesion check (as admin)
my $q = new CGI;
my $sid = $q->cookie("affelio-$af->{user__nickname}");
my $session = new CGI::Session(undef, 
			       $sid, 
			       {Directory=> $af->{site__session_dir}});

my $TMPL_FILE="";
if( (!$session) || ($session->param("type") ne "self")  ){
    # Is the session alive?
    # Is the user the admin of this site?
    # if not....
    debug_print("send_handshake.cgi: login is needed.");

    $TMPL_FILE 
	= "$af->{site__fs_root}/templates/$af->{site__template}/owner_side/login.tmpl";
    my $tmpl = new HTML::Template( filename => $TMPL_FILE,
				   die_on_bad_params => 0);
    $tmpl->param(reason_msg => "You haven't been authenticated.");
    $tmpl->param("tmpl_path" => "$af->{site__web_root}/templates/$af->{site__template}/owner_side/");
    print "Content-type: text/html; charset=UTF-8\n\n";
    print $af->translate_templateL10N($tmpl->output);
    exit(1);
}
debug_print("send_handshake.cgi: Session as the admin is OK.");

############################################################################
#Read input
my $target_url="";
my $target_xml_url="";

$target_url = $q->param("URL");
if(!$target_url){
    error($q,"Target URL is not defined.");
}

######################
#Distill valid URL
######################
my $wi = new Affelio::misc::WebInput;
$target_url = $wi->PTN_URL($target_url);
if($target_url eq ""){
    error($q,"Target URL is invalid!!");
}

######################
#Remove "/" from the end of $target_url
######################
$target_url =~ s/\/$//;
debug_print("send_HandShake: $target_url\n");
$target_xml_url = $target_url . "/bin/xml-rpc-serv.cgi";
debug_print("send_HandShake: $target_xml_url\n");

###########################################
# Get current time;
my $cur_time = get_timestamp();


###########################################
#DH key generation
my $mydh = Crypt::DH->new;
#RFC 2412 - The OAKLEY Key Determination Protocol
#Group 1:  A 768 bit prime
my $DH_g="2";
my $DH_p="1552518092300708935130918131258481755631334049434514313202351194902966239949102107258669453876591642442910007680288864229150803718918046342632727613031282983744380820890196288509170691316593175367469551763119843371637221007210577919";
$mydh->g($DH_g);
$mydh->p($DH_p);
#
#Step (1):  create my public_key
$mydh->generate_keys;
my $my_DH_pub_key_str = $mydh->pub_key->bstr;
my $my_DH_pri_key_str = $mydh->priv_key->bstr;

debug_print("send_HandShake: pri_key = $my_DH_pri_key_str [" . length($my_DH_pri_key_str) . "]digits");
debug_print("send_HandShake: pub_key = $my_DH_pub_key_str [" . length($my_DH_pub_key_str) . "]digits");


###########################################
# Send HandShake to the URL
my $ret="";
try{
    $ret = send_HandShake(dest_uri =>  $target_xml_url, 
			  timestamp => $cur_time,
			  my_nickname =>  $af->{user__nickname},
			  my_AFID  =>  $af->{site__web_root},
			  DH_pub_key_str => $my_DH_pub_key_str
			  );
}catch Affelio::exception::IOException with{
    my $E = shift;
    error($q, "<PRE>" . $E . "</PRE>");
}catch Affelio::exception::Exception with{
    my $E = shift;
    error($q, "<PRE>" . $E .  "</PRE>");
};
if($ret->{flerror} == 1){
    #XML-RPC communication was successful. 
    #But the peer returned error. denyetc...
    error($q, "<PRE>XML-RPC peer denied RPC.</PRE>");
}


###########################################
# Save peer's info into pending_DB
my $tmpdb= new Affelio::SNS::Handshaker_tmpDB($af);
$tmpdb->add_sent_Handshake($cur_time,
			   $target_xml_url,
			   "",
			   $cur_time,
			   $my_DH_pri_key_str);
debug_print("send_HandShake: DB(W) $target_url => $cur_time\n");


###########################################
# Print output
my $TMPL_FILE = "../templates/$af->{site__template}/owner_side/handshake_sent.tmpl";
my $tmpl = new HTML::Template( filename => $TMPL_FILE);
$tmpl->param(target_url => $target_url);
$tmpl->param(mypage_url => "$af->{site__web_root}/admin.cgi");
$tmpl->param("tmpl_path" => "$af->{site__web_root}/templates/$af->{site__template}");

print "Content-type: text/html; charset=UTF-8\n\n";
print $af->translate_templateL10N($tmpl->output);

