#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: logoutexec.cgi,v 1.4 2005/07/01 08:19:41 slash5234 Exp $

use strict;

use lib("../extlib");
use CGI qw(-unique_headers);
$CGI::DISABLE_UPLOADS = 1;
$CGI::POST_MAX = 102_400;
use CGI::Session qw(-ip_match);
use HTML::Template;
use Error qw(:try);

use lib("../lib");
use Affelio;
use Affelio::SNS::Handshaker_c;
use Affelio::misc::CGIError;
use Affelio::misc::Debug;
use Affelio::misc::NetMisc;
use Affelio::misc::MyCrypt;
use Affelio::misc::Time;

my $q = new CGI;
############################################################################
#Load Affelio
############################################################################
my $cfg_dir = "..";
my $af;
try{
    $af = new Affelio(ConfigDir => $cfg_dir);
}catch Error with{
    my $e = shift;
    error($q, "Affelio load error.\n" . $e);
};
my $wi = new Affelio::misc::WebInput;

############################################################################
#Check session w/ cookie
############################################################################
my $sid = $q->cookie("affelio-$af->{user__nickname}");
my $session = new CGI::Session(undef, 
			       $sid, 
			       {Directory=> $af->{site__session_dir}});


if($session){
    #Output expired cookie and redirect the user to index.
    $session->delete();
    undef($session);

    #Output expired cookie and redirect the user to index.
    my $cookie = $q->cookie ( -name => "affelio-$af->{user__nickname}",
                              -value => $sid,
                              -path => URL2path($af->{site__web_root}),
                              -expires => "-1d"
			      );

    print $q->redirect( -url => $af->{site__web_root},
                        -cookie => $cookie);

}
