#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: loginexec.cgi,v 1.5 2005/07/01 08:19:41 slash5234 Exp $

use strict;

use lib("../extlib");
use CGI qw(-unique_headers);
$CGI::DISABLE_UPLOADS = 1;
$CGI::POST_MAX = 102_400;
use CGI::Session qw(-ip_match);
use HTML::Template;
use Error qw(:try);

use lib("../lib");
use Affelio;
use Affelio::misc::CGIError;
use Affelio::misc::Debug;
use Affelio::misc::Time;
use Affelio::misc::NetMisc;
use Affelio::misc::MyCrypt;
use Affelio::misc::WebInput;
use Affelio::SNS::Handshaker_c;

my $q = new CGI;

############################################################################
#Load Affelio
############################################################################
my $cfg_dir = "..";
my $af;
try{
    $af = new Affelio(ConfigDir => $cfg_dir);
}catch Error with{
    my $e = shift;
    error($q, "Affelio load error.\n" . $e);
};
my $wi = new Affelio::misc::WebInput;

############################################################################
#Authentication check
############################################################################
my $username = $wi->PTN_word($q->param("username"));
my $password = $wi->PTN_through($q->param("password"));
my $forward_URL = $wi->PTN_URL($q->param("forward_URL"));

debug_print("  username = $username\n");
debug_print("  password = $password\n");
debug_print("  $af->{site__password}\n");
debug_print("  $forward_URL\n");

if(  (verify_password($password, $af->{site__password}) > 0) 
     && ($username eq $af->{site__username})                  ){

    debug_print("loginexec.cgi: AUTH Ok.\n");
    #login OK
}else{

    #login failed.
    debug_print("loginexec.cgi: AUTH NG.\n");

    my $TMPL_FILE 
	= "$af->{site__fs_root}/templates/$af->{site__template}/owner_side/loginfailed.tmpl";
    my $tmpl = new HTML::Template( filename => $TMPL_FILE);
    $tmpl->param(web_root => $af->{site__web_root});
    $tmpl->param("tmpl_path" => "$af->{site__web_root}/templates/$af->{site__template}");
    print "Content-type: text/html; charset=UTF-8\n\n";
    print $af->translate_templateL10N($tmpl->output);

    debug_print("loginexec.cgi: exit(1).\n");    
    exit(1);
}


############################################################################
#Startup session
############################################################################
my $ss = new CGI::Session("driver:File", 
			  undef, 
			  {Directory=> $af->{site__session_dir}});

#Set values into session
$ss->param("user_afid", $af->{site__web_root});
$ss->param("user_nickname", $af->{user__nickname});
$ss->param("type", "self");
#current time
#expire time

$ss->expire('+12h');

debug_print("loginexec.cgi: startup_session finished.\n");    


############################################################################
#Output
############################################################################

#Retrieve a sesion_id
my $session_id = $ss->id();

#Prepare a cookie with the session_id
my $cookie = $q->cookie ( -name => "affelio-$af->{user__nickname}",
                          -value => $session_id,
                          -path => URL2path($af->{site__web_root}));

debug_print("loginexec.cgi: new cookie [$session_id]\n");
debug_print("loginexec.cgi: new cookie [" . URL2domain($af->{site__web_root}) .  "]\n");
debug_print("loginexec.cgi: new cookie [" . URL2path($af->{site__web_root}) .  "]\n");


#Print output
if($forward_URL ne ""){
    print $q->redirect( -url => $forward_URL,
			-cookie => $cookie);
}else{
    print $q->redirect( -url => "$af->{site__web_root}/admin.cgi",
			-cookie => $cookie);
}

exit(1);
