#!/usr/bin/perl

use strict;
use lib("../../lib");
use AffelioApp;
use lib("../../extlib");
use CGI;
use Cwd;

my $cgi = new CGI();

#AffelioAppを初期化
my $afap = new AffelioApp(ConfigDir => Cwd::getcwd(),
			  cgi => $cgi);

#Content-typeを出力
print "Content-type: text/html;";
print "Pragma: no-cache", "\n\n"; 

#HTML Header Partを出力
my $out_head = $afap->get_HTML_header("Message Board Application");
print $out_head;

##################################################
#Application-dependentなロジック

my $write_access = $afap->check_access("write");
#Output textarea if "write" access_type is permitted for this user.
if($write_access){

    #print out textarea

}

#Print previous messages if "DF_read" access_type is permitted for this user.
my $read_access = $afap->check_access("DF_read");
if($read_access){

    #Show previous message

}

##################################################
#HTML Footer Partを出力
my $out_foot = $afap->get_HTML_footer();
print $out_foot;

#EOF
