#!/usr/bin/perl
# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

our $mymode="owner";

require 'init.pl';

$diary->checkAccess('write_diary');

my $title = $afap->{cgi}->param('title');
my $contents = $afap->{cgi}->param('contents');

my $tmpl;
if($afap->{cgi}->param('submit')) {
	# send trackback ping
	if ($afap->{cgi}->param('tping_url')) {
		$diary->sendTrackbackPing($afap->{cgi}->param('tping_url'), $title, $contents);
	}
	
	# add entry
	$diary->addEntry($title, $contents);
	
	# update images
	$diary->removeUploadedImage;
	if ($afap->{cgi}->param('filename_1')) {
		$diary->saveUploadedImage($afap->{cgi}->param('filename_1'));
	}
	if ($afap->{cgi}->param('filename_2')) {
		$diary->saveUploadedImage($afap->{cgi}->param('filename_2'));
	}

	print $diary->getRedirection('list_diary.cgi');
	exit;
}
else {
	print $diary->get_HTML_header;
	if($afap->{cgi}->param('confirm')) {
		$tmpl =  new HTML::Template(filename => "./templates/write_diary_confirm.tmpl");
		$tmpl->param(
			TITLE_SHOW => $diary->escape($title),
			CONTENTS_SHOW => $diary->escape($contents),
		);
	}
	else { # edit
		$tmpl =  new HTML::Template(filename => "./templates/write_diary_edit.tmpl");
	}
}

if ($contents) {
	$tmpl->param(
		TITLE => $title,
		CONTENTS => $contents,
	);
}

print $tmpl->output;

print $diary->get_HTML_footer;
