#!/usr/bin/perl
# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require 'init.pl';

my $id = $afap->{cgi}->param('id') or $diary->errorExit('$B5-;vHV9f$,;XDj$5$l$F$$$^$;$s(B');

my $tmpl = HTML::Template->new(filename => "./templates/show_trackback.tmpl");

my @ts = $diary->getTrackbacks($id);
my @trackbacks;
foreach (@ts) {
	my ($sec, $min, $hour, $mday, $mon, $year) = localtime($_->{timestamp});
	$year += 1900; $mon += 1;
	push @trackbacks, {
		TITLE		=> $diary->escape($_->{title}),
		BLOG_NAME	=> $diary->escape($_->{blog_name}),
		URL		=> $_->{url},
		EXCERPT		=> $diary->escape($_->{excerpt}),
		DATE		=> "$year-$mon-$mday",
	};
}
$tmpl->param(PING_URL => $afap->get_site_info("web_root") . "/apps/$diary->{afap}->{install_name}/tb.cgi/$id", TRACKBACKS => \@trackbacks);

print $diary->get_HTML_header;
print $diary->getURLDescription($id);
print $tmpl->output;
print $diary->get_HTML_footer;
