#!/usr/bin/perl
# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require 'init.pl';

our $mymode="owner";
$diary->checkAccess('write_diary');

if ($afap->{cgi}->param('save_state')) {
	my $type = $afap->{cgi}->param('type');
	if ($type eq 'import') { 
		$diary->setRDFURL($afap->{cgi}->param('url'));
		print $diary->getRedirection('external_blog.cgi'); exit;
	}
	else { # normal diary
		$diary->unsetRDFURL;
		print $diary->getRedirection('list_diary.cgi'); exit;
	}
}

my $tmpl = new HTML::Template(filename => './templates/owner.tmpl');
my $url = $diary->getRDFURL;
if ($url) {
	$tmpl->param(
		URL	=>	$url,
		SELECT_IMPORT => 'checked'
	);
}
else {
	$tmpl->param(SELECT_DIARY => 'checked');
}

eval { require XML::Parser; } or $tmpl->param(NO_PARSER => 1);

print $diary->get_HTML_header;
print $tmpl->output;
print $diary->get_HTML_footer;
