# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use strict;

use lib("../../extlib");
use HTML::Template;
use CGI;
use Cwd;
#
use lib("../../lib");
use AffelioApp;
#
use Diary;

our $cgi = new CGI();

our $afap = new AffelioApp(ConfigDir => Cwd::getcwd(),
			   cgi => $cgi);

if(our $mymode eq "owner"){
    $afap->set_owner_mode();
}

our $diary = new Diary($afap);

unless ($afap->check_access("DF_access")) {
	$diary->accessErrorExit(' あなたはこのページへのアクセス権限がありません ');
}

##########################################################################
1;
