#!/usr/bin/perl
# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require 'init.pl';

my $urlfile = $diary->{datadir}.'url';

my $writable = 0;
if($afap->check_access("write_diary")){
	$writable = 1;
}

eval { require XML::Parser; } or $diary->errorExit("XML::Parser is not available");

# print header
my $header =	
	"Content-type: text/html; charset=UTF-8\n".
	"Pragma: no-cache\n\n".
	$afap->get_HTML_header($diary->{header_titile});

# set url
if ($afap->{cgi}->param('set_url')) {
	$diary->setRDFURL($afap->{cgi}->param('url'));
}
# unset url
elsif ($afap->{cgi}->param('remove_urlfile')) {
	$diary->unsetRDFURL;
	print $diary->getRedirection('list_diary.cgi');
	exit;
}

# load rss file and get url of rdf
my $rssfile = $diary->getRDFURL;

# if file was not found, show configuration file
unless ($rssfile) {
	$diary->checkAccess('write_diary');
	my $tmpl = new HTML::Template(filename => "./templates/external_blog_conf.tmpl");
	print $header;
	print $tmpl->output;
	print $diary->get_HTML_footer;
	exit;
}

# send request 
my $req = new HTTP::Request(GET => $rssfile);
my $ua  = new LWP::UserAgent;
my $res = $ua->request($req);
my $str;
if ($res->is_success) {
	$str = $res->content;
	$str =~ s/&/&amp;/g; # escape '&'
}
else {
	unlink($urlfile) if (-f $urlfile);
	print $diary->errorExit("RDFの取得に失敗しました。URLが間違っている可能性があります");
}

# parse and output
use lib 'extlib';
use XML::RSS;

my $rss = new XML::RSS;
$rss->parse($str);

my @entries;
my @entry_list;
my $i = 0;
foreach (@{ $rss->{items} }) {
	push @entries, {
		TITLE	=> $_->{'title'},
		LINK	=> $_->{'link'},
		CONTENTS=> &escape_html($_->{'description'}),
		DATE	=> $_->{dc}->{'date'},
	};
	push @entry_list, {
		TITLE	=> $_->{'title'},
		LINK	=> $_->{'link'},
	};
	last if (++$i >= 10);
}

my $tmpl = new HTML::Template(filename => "./templates/external_blog.tmpl");
$tmpl->param(
	WRITABLE	=> $writable,
	RSS_URL		=> $rssfile,
	TITLE_MAIN	=> $rss->channel('title'),
	LINK_MAIN	=> $rss->channel('link'),
	ENTRIES		=> \@entries,
	ENTRY_LIST	=> \@entry_list,
);

print $header;
print $tmpl->output;
print $diary->get_HTML_footer;

sub escape_html {
	my $html = shift;

	if ($html =~ /&lt;/) {
		$html =~ s/&lt;(.*)&gt;//g;
		$html =~ s/&amp;/&/g;
		$html =~ s/&(quot|apos);/"/g;
	}

	$html =~ s/&/&amp;/g;
	$html =~ s/['"]/&quot;/g;
	$html =~ s/</&lt;/g;
	$html =~ s/>/&gt;/g;
	
	# allow <br>,<p>,<a>,<i>,<b>,<strong>,<em>,<u>,<font>
	$html =~ s/&lt;(\/?)(br|p|a|i|b|strong|em|u|font)[^&]*&gt;/<$1$2$3>/gi;
	$html =~ s/&lt;a +href=&quot;([^&]*)&quot;([^&]*)&gt;/<a href="$1" $2>/gi;
	
	return $html;
}
