# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
use strict;

use lib("../../extlib");
use HTML::Template;
use CGI;
use Cwd;
#
use lib("../../lib");
use AffelioApp;
#
use Diary;


our $cgi = new CGI();

#AffelioAppを初期化
our $afap = new AffelioApp(ConfigDir => Cwd::getcwd(),
			   cgi => $cgi);

if(our $mymode eq "owner"){
    $afap->set_owner_mode();
}

#Content-typeを出力
print "Content-type: text/html; charset=UTF-8\n";
print "Pragma: no-cache", "\n\n"; 

#HTML Header Partを出力
print $afap->get_HTML_header("Affelio Diary");
# 読み込みアクセス権限をチェック
unless ($afap->check_access("DF_access")) {
    print "<div><div>";
    &errorExit("あなたにはこのページの読み込み権限がありません");
}

my $tmpl = HTML::Template->new(filename => "./templates/menu.tmpl");

# カレンダーを表示
our $diary = new Diary($afap);

my $calender = "";
if($afap->{cgi}->param('year') and $afap->{cgi}->param('month')) {
	$calender = $diary->getCalender($afap->{cgi}->param('year'), $afap->{cgi}->param('month'));
}
elsif($afap->{cgi}->param('id')) {
	my $id = 
	my @date = $diary->getall("SELECT year, month FROM $diary->{entry_table} WHERE id = ".$afap->{cgi}->param('id'));
	$calender = $diary->getCalender($date[0]->{year}, $date[0]->{month});
}
else {
	$calender = $diary->getCalender;
}

# アーカイブを取得
my @archives = $diary->getall("SELECT DISTINCT year, month FROM $diary->{entry_table} LIMIT 10");
if($#archives >= 0) {
	shift @archives unless $archives[0]->{year};
	$tmpl->param(HAS_ARCHIVE => "1", ARCHIVES => \@archives);
}

# 最近のエントリーを取得
my @entries = $diary->getall("SELECT id, title FROM $diary->{entry_table} ORDER BY timestamp DESC LIMIT 5");
if($#entries >= 0) {
	$tmpl->param(HAS_ENTRY => "1", RECENT_ENTRIES => \@entries);
}

$tmpl->param(CALENDER => $calender, RSS => $afap->get_site_info("web_root") . "/apps/diary/get_rss.cgi");

$tmpl->param(access_control_URL => $afap->get_URL("access_control"));


print $tmpl->output;

# エラーを吐いて終わる
sub errorExit {
	my $msg = shift;
print<<ACCESS_ERR;
<div class="information">
<h3>エラー</h3>
<p>$msg</p>
</div>
ACCESS_ERR
require ("./common/footer.pl");
	exit;
}

sub getParam {
	my $key = shift;
	my $val = $afap->{cgi}->param($key);
	if ($val) {
		$afap->set_session_param($key, $val);
		return $val;
	}
	return $afap->get_session_param($key);
}

sub unsetParam {
	my $key = shift;
	$afap->set_session_param($key, "");
}

##########################################################################
1;
