#!/usr/bin/env perl
# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use strict;

use Diary;

my $diary = new Diary("ensf");

if($ARGV[0] eq '-r') {
	my @res = $diary->getEntries($ARGV[1], $ARGV[2], $ARGV[3]);
	foreach(@res) {
		print "title: ".$_->{title}."\n\n".$_->{contents}."\n";
	}
}
elsif($ARGV[0] eq '-w') {
	$diary->addEntry($ARGV[1], $ARGV[2]);
	print "title: ".$ARGV[1]."\n\n".$ARGV[2]."\n";
}
elsif($ARGV[0] eq '-cw') {
	$diary->addComment($ARGV[1], $ARGV[2], $ARGV[3]);
	print "id => $ARGV[1]\nuser: $ARGV[2]\n$ARGV[3]\n";
}
elsif($ARGV[0] eq '-cr') {
	my @res = $diary->getComments($ARGV[1]);
	foreach(@res) {
		print "user: $_->{user}\n$_->{comment}\n";
	}
}
else {
	die("invalid arguments\n");
}

