#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use strict;
use lib("../../extlib");
use CGI;
use Cwd;
use lib("../../lib");
use AffelioApp;

our $cgi = new CGI();
#AffelioAppを初期化
our $afap = new AffelioApp(ConfigDir => Cwd::getcwd(),
			   cgi => $cgi);

# 読み込みアクセス権限をチェック
if ($afap->check_access("DF_access")) {
  my $image = $afap->{cgi}->param('image');
  my $id = $afap->{cgi}->param('id');
  my $type = $afap->{cgi}->param('type');
  my $filepath;
  if ($type eq "thumbnail") {
	$filepath = $afap->get_userdata_dir()."/".$id."/thumbnail/".$image;
  }elsif($type eq "large"){
	$filepath = $afap->get_userdata_dir()."/".$id."/".$image;
  }else{
	$filepath = "./resource/emp.jpg";
  }
  if ($image eq ""){
	$filepath = "./resource/emp.jpg";
  }
  my $imgtype = 'jpeg';

#// 画像オープン
  open(IMG, "$filepath") or die;

#// イメージ表示
  binmode IMG;
  binmode STDOUT;
  print "Content-type: image/$imgtype\n\n";
  print while (<IMG>);

#// 画像クローズ
  close(IMG);
}
  exit(0);
