#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require('./common/header.pl');
my $user = $afap->{cgi}->param("user");
my $edit = 0;
my $col_num=4;

# 本人（アルバム追加可）
if ($afap->get_visitor_info("type") eq "self"){
    $edit = 1;
}

my $tmpl = HTML::Template->new(filename => "./templates/list_album.tmpl");
my @entries_param;
my @entries;
my @images;
@entries = $album->getAllEntries;
$tmpl->param(install_title => $afap->get_app_info("install_title"));
$tmpl->param(EDITABLE => $edit);

if ($afap->{cgi}->param("mode") eq "thumbnail"){
  $tmpl->param(THUMB => 1);

# サムネイルの表示
my @image_filelist;
my @image_files;
my @image_row;
  foreach(@entries){
    my $album_data = $album->getEntry($_->{id});
    	push @image_filelist,
    	{
          IMAGE => $album_data->{image},
          ID2 => $_->{id}
        }
  }

        for (my $i=0; $i<($#image_filelist+1)%$col_num; $i++){
              	push @image_filelist, "";
        }

      	for (my $i=0; $i<($#image_filelist+1)/$col_num; $i++){
		$i_num=$i*$col_num;
      		for (my $j=0; $j<$col_num; $j++){
                  my @images=$album->getAllImage($entries[$i_num+$j]->{id});
			push @image_files,
       			{
#	                        IMAGE => $image_filelist[$i_num+$j]->{image},
                          IMAGE => $images[0]->{image},
       				ID2 => $id,
       			};
      		}
		push @image_row,
              	{IMG => [@image_files[$i_num..($i_num+($col_num-1))]]};

       	}
	$tmpl->param(THUMBNAIL => \@image_row);

  

}else{
  my $i = 0;
  foreach(@entries) {
	my ($sec, $min, $hour, $mday, $mon, $year) = localtime($_->{update_time});
  	$mon+=1;
  	$year+=1900;
        @images = $album->getAllImage($_->{id});

	push @entries_param,
	{
		MONTH	=>	$mon,
		DAY	=>	$mday,
		#TIME	=>	sprintf("%02d:%02d", $hour, $min),
		TITLE	=>	$_->{title},
		CONTENTS=>	$_->{contents},
		COMMENT_NO =>	$album->getCommentsNo($_->{id}),
		TRACKBACKS =>	$album->getTrackbacksNo($_->{id}),
		ID	=>	$_->{id},
                IMAGE	=>	$images[0]->{image},
		#EDITABLE=>	$edit
	};
  }
  $tmpl->param(ENTRIES => \@entries_param);
}

print $tmpl->output;

require("./common/footer.pl");
