#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require './common/header.pl';
my $id = $afap->{cgi}->param("id");
my $pkey=$afap->{cgi}->param("pkey");
my $entry = $album->getEntry($id);
my $edit = 0;
my $image_data = $album->getImage($id,$pkey);
my $tmpl = HTML::Template->new(filename => "./templates/large_image.tmpl");

# 本人（編集可）
my $afid = $afap->get_visitor_info("afid");
if($afap->check_access("add_image") && ($image_data->{afid} eq $afid)) {
    $tmpl->param(EDIT_COMMENT => 1);
}
# サイトオーナー（編集可）
if ($afap->get_visitor_info("type") eq "self"){
    $tmpl->param(EDIT_COMMENT => 1);
}


# アルバム情報
$tmpl->param(
	TITLE	=> $entry->{title},
	ID	=> $id,
  	PKEY	=> $pkey,
);

my $user_uri='';
if ($image_data->{user} eq ''){
	$user_uri="ななしさん";
}else{
    $user_uri='<A HREF="'.$afap->get_site_info("web_root").'/outgoing.cgi?dest_url='.$image_data->{afid}.'">'.$image_data->{user}."</A>";
}

$tmpl->param(IMAGE_OWNER => $user_uri);
if ($image_data->{title}){
	$tmpl->param(HAS_TITLE => '1');
	$tmpl->param(IMAGE_TITLE => $image_data->{title});
}
if ($image_data->{comment}){
	$tmpl->param(HAS_COMMENT => '1');
	$tmpl->param(IMAGE_COMMENT => $image_data->{comment});
}
if ($image_data->{image}){
	$tmpl->param(HAS_IMAGE => '1');
	$tmpl->param(IMAGE => $image_data->{image});
}



# 画像表示
my @image_files;
my @image_row;
my @image_filelist=$album->getAllImage($id);
$i=0;
$max=$#image_filelist;
foreach(@image_filelist){
  if ($_->{pkey} eq $pkey){
    if ($i>0){
	$tmpl->param(
		HAS_PREV => 1,
	        PREV_IMAGE=> $image_filelist[$i-1]->{pkey}
     	);
    }
    if ($i<$max){
	$tmpl->param(
		HAS_NEXT => 1,
	        NEXT_IMAGE=> $image_filelist[$i+1]->{pkey}
     	);
    }
  }
  $i++;
}      

print $tmpl->output;

require './common/footer.pl';
