#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require './common/header.pl';
my $id = $afap->{cgi}->param("id");
my $pkey = $afap->{cgi}->param("pkey");

# 本人（編集可）
# サイトオーナー（編集可）
my $image_data = $album->getImage($id,$pkey);
my $afid = $afap->get_visitor_info("afid");

if($afap->check_access("add_image")){
	unless($image_data->{afid} eq $afid || $afap->get_visitor_info("type") eq "self") {
		&errorExit("あなたはこのページにアクセスする権限がありません");
        }
}

my $tmpl = HTML::Template->new(filename => "./templates/edit_comment.tmpl");

$tmpl->param(ID => $id);
$tmpl->param(PKEY => $pkey);


# 編集完了
if($afap->{cgi}->param("edit")) {
#my $afid = $afap->get_visitor_info("afid");
  
$album->updateImage($id, $afap->{cgi}->param("title"),
			$afap->{cgi}->param("comment"),
			$image_data->{image});
$tmpl->param(DONE => "1", DONE_LABEL => "内容を変更しました");
}

# コメント編集画面
elsif ($afap->{cgi}->param("comment_edit")){
	$tmpl->param(EDIT => "1");
	my $entry = $album->getImage($id,$pkey);
	$entry->{comment} =~ s/<br \/>/\n/g;
	$tmpl->param(
		TITLE => $entry->{title}, 
		COMMENT => $entry->{comment},
		PKEY => $entry->{pkey},
	);
}

print $tmpl->output;

require './common/footer.pl';
