# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use strict;
use lib("../../extlib");
use HTML::Template;
use CGI;
use Cwd;
#
use lib("../../lib");
use AffelioApp;
#
use Album;

our $cgi = new CGI();

#AffelioAppを初期化
our $afap = new AffelioApp(ConfigDir => Cwd::getcwd(),
			   cgi => $cgi);

if(our $mymode eq "owner"){
    $afap->set_owner_mode();
}

#Content-typeを出力
print "Content-type: text/html; charset=UTF-8\n";
print "Pragma: no-cache", "\n\n"; 

#HTML Header Partを出力
print $afap->get_HTML_header("Affelio Photo Album");
# 読み込みアクセス権限をチェック
unless ($afap->check_access("DF_access")) {
    &errorExit("あなたにはこのページにアクセスする権限がありません");
}

our $album = new Album($afap);

# エラーを吐いて終わる
sub errorExit {
	my $msg = shift;
  	my $affelio_id = AffelioApp::get_visitor_info("afid");
 	my $visitor_type=AffelioApp::get_visitor_info("type");

if($visitor_type eq ""){
    $visitor_type="pb";
}

print<<ACCESS_ERR;

<div class="afPubContentHeading">
<table border="0" cellspacing="0" width=100%>
<tr><td align="left">
エラー</td>
<td align="right">
<font size="-2">($visitor_type モード)</font>  
<a href="javascript:void(0);" onClick="showHide('c0');">
<font size="-2">login/logout</font></a></td></tr></table>
<div class="sidehide" id="c0">
現在のログイン：　$affelio_id <BR>
現在のモード：　　$visitor_type <BR>
<BR>
<FORM class="afPubLoginarea" ACTION="../../bin/loginexec.cgi" METHOD="POST">
ログインID: <INPUT TYPE="text" NAME="username" SIZE="20"> 
パスワード: <INPUT TYPE="password" NAME="password" SIZE="10">
<INPUT TYPE="submit" NAME="button" VALUE="ログイン">
　　<A HREF="./bin/logoutexec.cgi">ログアウト</A>
</FORM>
</div>
</div><!--afPubContentHeading-->

<div class="information">
<p>$msg</p>
</div>
ACCESS_ERR
require ("./common/footer.pl");
	exit;
}

##########################################################################
1;
