#!/usr/bin/perl
use strict;

package AffelioApp::SNSGateway;
{
    use Exporter;
    @AffelioApp::SNSGateway::ISA = "Exporter";
    @AffelioApp::SNSGateway::EXPORT = qw (read_config write_config);

    sub write_config{
	my $afap =shift;
	my $u =shift;
	my $p =shift;

	my $cfg = Config::Tiny->new();

	$cfg->{user}->{username} = $u;
	$cfg->{user}->{password} = $p;

	my $filename = $afap->get_userdata_dir() . "/config.ini";
	$cfg->write($filename);
	
	return();
    }

    sub read_config{
	my $afap =shift;
	my $username="";
	my $password="";

	my $filename = $afap->get_userdata_dir() . "/config.ini";

	my $cfg = Config::Tiny->new();
	$cfg = Config::Tiny->read($filename);

	if($cfg){
	    $username = $cfg->{user}->{username};
	    $password = $cfg->{user}->{password};
	}
	
	return({username => $username,
		password => $password}
	       );
    }

}
1;
