#!/usr/bin/perl

use lib("../../extlib");  #general
use HTML::Template;
use CGI;
use Cwd;
use Jcode;
#
use lib("../../lib");  #Affelio
use AffelioApp;
use Affelio::misc::CGIError;
#
use lib("./extlib/");  #WWW:Mixi
use WWW::Mixi;
use HTTP::Cookies;
use HTTP::Request::Common;
#
use lib("./lib/"); 
use AffelioApp::SNSGateway;

use strict;

###########################################################################
#init
###########################################################################
my $cgi = new CGI();

#AffelioAppを初期化
my $afap = new AffelioApp(ConfigDir => Cwd::getcwd(),
			  cgi => $cgi);
$afap->set_owner_mode();
my $in_username = $cgi->param("username");
my $in_password = $cgi->param("password");

###########################################################################
#Output
###########################################################################
#Content-typeを出力
print "Content-type: text/html; charset=UTF-8\n";
print "Pragma: no-cache", "\n\n"; 

#HTML Header Partを出力
print $afap->get_HTML_header("Affelio Mixi Gateway");

# 読み込みアクセス権限をチェックし、内容表示
unless ($afap->check_access("setting")
	&&
	$afap->check_access("DF_read")){
    print "あなたにはこのページの管理権限がありません";
    
    #HTML Footer Partを出力
    print $afap->get_HTML_footer();

    exit(1);
}

###########################################################################
#Save input data into config_file 
###########################################################################
if(($in_username ne "") && ($in_password ne "")){
    write_config($afap, $in_username, $in_password);
}

###########################################################################
#Read configuration file
###########################################################################
my $userinfo = read_config($afap);

my $tmpl = HTML::Template->new(filename => "./templates/admin.tmpl",
			       die_on_bad_params => 0);

$tmpl->param(install_title => $afap->get_app_info("install_title"));
$tmpl->param(username => $userinfo->{username});
$tmpl->param(password => $userinfo->{password});
$tmpl->param(accesscontrol_url => $afap->get_URL("access_control"));

print $tmpl->output;

#HTML Footer Partを出力
print $afap->get_HTML_footer();

exit(1);
