#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: admin.cgi,v 1.28 2005/07/03 16:16:31 slash5234 Exp $

use strict;

use lib("./extlib");
use CGI qw(-unique_headers);
$CGI::DISABLE_UPLOADS = 0;
$CGI::POST_MAX = 1024_000;
use Error qw(:try);
use CGI::Session qw(-ip_match);
use HTML::Template;
use Fcntl;

use lib("./lib");
use Affelio;
use Affelio::misc::CGIError;
use Affelio::misc::Debug qw( debug_print);
use Affelio::misc::Time;
use Affelio::misc::NetMisc;
use Affelio::misc::WebInput;
use Affelio::exception::CommunicationException; 

############################################################################
#Load Affelio
############################################################################
debug_print("admin.cgi: start.");

my $cfg_dir = ".";
my $af;
try{
    $af = new Affelio(ConfigDir => $cfg_dir);
}catch Error with{
    my $e = shift;
    print "Content-type: text/html; charset=UTF-8\n";
    print "Pragma: no-cache", "\n\n";
    print "<HTML><PRE>Affelio load error.<BR>$e<BR><BR>" . $e->stacktrace . "</PRE></HTML>";
    exit(1);
};
debug_print("admin.cgi: AF loaded.");
my $wi = new Affelio::misc::WebInput();

############################################################################
#Check session w/ cookie
############################################################################
my $TMPL_FILE=""; 
my $q = new CGI;
my $sid = $q->cookie("affelio-$af->{user__nickname}");
debug_print("admin.cgi: sid from cookie = $sid");
my $session="";
if($sid){
    $session = new CGI::Session(undef, 
				$sid, 
				{Directory=> $af->{site__session_dir}});
    debug_print("admin:cgi Existing session: [" . $session->id . "]");
}

if( (!$session) || ($session->param("type") ne "self")  ){
    # Is the session alive?
    # Is the user the admin of this site?
    # if not....
    debug_print("admin.cgi: login is needed.");

    print "Content-type: text/html; charset=UTF-8\n";
    print "Pragma: no-cache", "\n\n";
    print get_HTML_header();

    $TMPL_FILE = "$af->{site__fs_root}/templates/$af->{site__template}/owner_side/login.tmpl";
    my $tmpl = new HTML::Template( filename => $TMPL_FILE,
				   die_on_bad_params => 0);
    $tmpl->param(reason_msg => "You haven't been authenticated.");
    $tmpl->param("tmpl_path" => "$af->{site__web_root}/templates/$af->{site__template}/owner_side/");
    $tmpl->param("style_path" => $af->{site__web_root} . "/skins/" . $af->{userpref__skin});
    $tmpl->param("forward_URL" => $q->self_url);

    print $af->translate_templateL10N($tmpl->output);
    print get_HTML_footer();
    exit(1);
}

debug_print("admin.cgi: Session as the admin is OK.");
$session->expire('+12h');

############################################################################
#Going to the owner mode
############################################################################
#Set this Affelio as owner mode.
$af->set_owner_mode();


############################################################################
#Invoking models
############################################################################
use Affelio::App::Admin::Messaging;
my %output_data = ("tmpl_path", "$af->{site__web_root}/templates/$af->{site__template}/owner_side/",
		   "style_path", $af->{site__web_root} . "/skins/" . $af->{userpref__skin},
		   "site_web_root", "$af->{site__web_root}",
		   "my_nickname", $af->{user__nickname},
		   "my_currentstatus", $af->{user__currentstatus},
		   "new_messages", Affelio::App::Admin::Messaging::get_new($af)
		   );

my $HTTP_forward_flag = 0;
my $forward_URL = "";
my $ret_msg="";
my $err_msg="";

my $admin_mode = $wi->PTN_mode($q->url_param("mode"));

#####################################################################
#Affelio Configuration
#####################################################################
if($admin_mode eq "config_affelio"){

    use Affelio::App::Admin::Configuration;

    my $sub_mode = $wi->PTN_mode($q->url_param("action"));
    if($sub_mode eq "submit" ){
	try{
	    Affelio::App::Admin::Configuration::configure($af, $q);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};
    }

    $TMPL_FILE = "$af->{site__fs_root}/templates/" .
	         "$af->{site__template}/owner_side/admin_affelio_config.tmpl";
    Affelio::App::Admin::Configuration::show($af,\%output_data);

#####################################################################
#Access Log
#####################################################################
}elsif($admin_mode eq "accesslog"){

    use Affelio::App::Admin::AccessLog;

    $TMPL_FILE = "$af->{site__fs_root}/templates/" .
	         "$af->{site__template}/owner_side/admin_access_log.tmpl";
    try{
	Affelio::App::Admin::AccessLog::show($af,$q,\%output_data);
    }catch Error with{
	my $e = shift;    $err_msg .= $e->stacktrace;
    };

#####################################################################
#Upload Image
#####################################################################
}elsif($admin_mode eq "uploadimage"){

    use Affelio::App::Admin::EditProfile;
    $TMPL_FILE = "$af->{site__fs_root}/templates/" .
	         "$af->{site__template}/owner_side/admin_editprofile.tmpl";

    my $sub_mode = $wi->PTN_mode($q->url_param("action"));
    if($sub_mode eq "submit" ){
	try{
	    $q->cgi_error 
		and error($q, "File transfer failed." . $q->cgi_error);

	    my $uploaded_filename = $wi->PTN_jpg_filename($q->param("file"))
		|| error($q, "File has not been transfered to server.");
	    my $fh = $q->upload( "file" );
	
	    sysopen(OUT, "$af->{site__user_dir}/profile_face.jpg", 
		    O_WRONLY|O_TRUNC|O_CREAT, 0755);
	    binmode $fh;
	    binmode OUT;
	    my $buffer="";
	    while (read ($fh, $buffer, 16384)){
		print OUT $buffer;
	    }
	    close OUT;
	}catch Error with{
	    my $e = shift;
	    $err_msg='<AF_M text="Error in uploading the image"><BR>' . $e;
	};

	Affelio::App::Admin::EditProfile::show_profileeditor($af, \%output_data);
    }else{
    }

#####################################################################
#Messages
#####################################################################
}elsif($admin_mode eq "messages"){

    use Affelio::App::Admin::Messaging;

    if( $q->url_param("action") eq "send_message" ){

	try{
	    $ret_msg=Affelio::App::Admin::Messaging::send_message($af, $q);
	    $ret_msg='<AF_M text="You message has been sent successfuly.">';
	}catch Affelio::exception::CommunicationException with{
	    my $E = shift;
	    $err_msg='<AF_M text="Could not send message."><BR>' . $E;
	};

	$TMPL_FILE = "$af->{site__fs_root}/templates/" .
	    "$af->{site__template}/owner_side/admin_showmessage_list.tmpl";

	try{
	    Affelio::App::Admin::Messaging::show_message_list($af, 
							  \%output_data);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

    }elsif( $q->url_param("action") eq "compose" ){
	$TMPL_FILE = "$af->{site__fs_root}/templates/" .
	    "$af->{site__template}/owner_side/admin_composemessage.tmpl";

	try{
	    Affelio::App::Admin::Messaging::compose($af,
						    $q,
						    \%output_data);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

    }elsif( $q->url_param("action") eq "show" ){
	$TMPL_FILE = "$af->{site__fs_root}/templates/" .
	    "$af->{site__template}/owner_side/admin_showmessage.tmpl";
	try{
	    Affelio::App::Admin::Messaging::mark_as_read($af,
						     $q->url_param("mid"));

	    Affelio::App::Admin::Messaging::show_message($af,
						     $q->url_param("mid"),
						     \%output_data);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

    }else{
	$TMPL_FILE = "$af->{site__fs_root}/templates/" .
	    "$af->{site__template}/owner_side/admin_showmessage_list.tmpl";
	
	try{
	    Affelio::App::Admin::Messaging::show_message_list($af, 
							  \%output_data);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};
    }

#####################################################################
#Edit skin
#####################################################################
}elsif($admin_mode eq "edit_skins"){

    use Affelio::App::Admin::EditSkins;

    if( $q->url_param("action") eq "submitcss" ){
	debug_print("admin.cgi: action=[submitcss]");
	try{
	    Affelio::App::Admin::EditSkins::save_css($af, $q);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

    }elsif( $q->url_param("action") eq "chooseskin" ){
	#Choose skin
	debug_print("admin.cgi: action=[chooseskin]");
	try{
	    Affelio::App::Admin::EditSkins::choose_skin($af, $q);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

    }elsif( $q->url_param("action") eq "backup" ){
	#backup skin
	debug_print("admin.cgi: action=[backup]");
	try{
	    Affelio::App::Admin::EditSkins::backup($af,$q);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

    }elsif( $q->url_param("action") eq "upload" ){
	#backup skin
	debug_print("admin.cgi: action=[upload]");
	try{
	    Affelio::App::Admin::EditSkins::upload($af,$q);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};
    }

    $TMPL_FILE = "$af->{site__fs_root}/templates/" .
	         "$af->{site__template}/owner_side/admin_edit_skins.tmpl";
    try{
	Affelio::App::Admin::EditSkins::show($af, \%output_data);
    }catch Error with{
	my $e = shift;    $err_msg .= $e->stacktrace;
    };
#####################################################################
#Edit templates
#####################################################################
}elsif($admin_mode eq "edit_templates"){

    use Affelio::App::Admin::EditTemplates;

    if( $q->url_param("action") eq "submit" ){
	#Retrieve the latest data from friends' sites.
	debug_print("admin.cgi: action=[submit]");

	try{
	    Affelio::App::Admin::EditTemplates::save_templates($af,$q);
	    Affelio::App::Admin::EditTemplates::rebuild($af);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};
    }elsif( $q->url_param("action") eq "rebuild" ){

	#Retrieve the latest data from friends' sites.
	debug_print("admin.cgi: action=[rebuild]");
	try{
	    Affelio::App::Admin::EditTemplates::rebuild($af);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};
    }

    $TMPL_FILE = "$af->{site__fs_root}/templates/" .
	         "$af->{site__template}/owner_side/admin_edit_templates.tmpl";

    try{
	Affelio::App::Admin::EditTemplates::show_templates($af, \%output_data);
    }catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
    };


#####################################################################
#Friends graph
#####################################################################
}elsif($admin_mode eq "friendsgraph"){

    use Affelio::App::Admin::FriendsGraph;

    if( $q->url_param("action") eq "retrieve" ){
	#Retrieve the latest data from friends' sites.
	debug_print("admin.cgi: action=[retrieve]");

	try{
	    Affelio::App::Admin::FriendsGraph::retrieve($af);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};
    }


    $TMPL_FILE = "$af->{site__fs_root}/templates/" .
	         "$af->{site__template}/owner_side/admin_friendsgraph.tmpl";
    try{
	Affelio::App::Admin::FriendsGraph::show_friendsgraph($af, \%output_data);
    }catch Error with{
	my $e = shift;    $err_msg .= $e->stacktrace;
    };
#####################################################################
#Edit Profile
#####################################################################
}elsif($admin_mode eq "editprofile"){

    use Affelio::App::Admin::EditProfile;

    $TMPL_FILE = "$af->{site__fs_root}/templates/" .
	         "$af->{site__template}/owner_side/admin_editprofile.tmpl";

    if( $q->url_param("mode2") eq "submit" ){
	#Profile data is being submitted.
	debug_print("admin.cgi: mode2=[submit]");

	try{
	    Affelio::App::Admin::EditProfile::save_profile($af,$q);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};
    }

    Affelio::App::Admin::EditProfile::show_profileeditor($af, \%output_data);

#####################################################################
#Group Member Table
#####################################################################
}elsif($admin_mode eq "group_member_table"){

    use Affelio::App::Admin::GroupMemberTable;

    debug_print("admin.cgi: mode2=[" . $q->url_param("mode2"));
    if($q->url_param("mode2") eq "submit"){
	try{
	    save_GroupMember_table($af, $q);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};
    }

    $TMPL_FILE = "$af->{site__fs_root}/templates/" .
	"$af->{site__template}/owner_side/admin_groupmember_table.tmpl";
    try{
	show_GroupMember_table($af, \%output_data);
    }catch Error with{
	my $e = shift;    $err_msg .= $e->stacktrace;
    };
#####################################################################
#Manage Friend
#####################################################################
}elsif($admin_mode eq "manage_friends"){

    use Affelio::App::Admin::ManageFriend;

    debug_print("admin.cgi: mode2=[" . $q->url_param("mode2"));
    if($q->url_param("mode2") eq "delete"){
	try{
	    Affelio::App::Admin::ManageFriend::remove_member($af, $q->url_param("uid"), $q);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

	$TMPL_FILE = "$af->{site__fs_root}/templates/" .
	    "$af->{site__template}/owner_side/admin_managefriends_top.tmpl";
	try{
	    Affelio::App::Admin::ManageFriend::manage_top($af, \%output_data);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};
    }elsif($q->url_param("mode2") eq "show_member"){
	##Show member#############

        $TMPL_FILE = "$af->{site__fs_root}/templates/" .
            "$af->{site__template}/owner_side/admin_managefriends_showmember.tmpl";
	try{
	    Affelio::App::Admin::ManageFriend::show_member($af, $q->url_param("uid"), \%output_data);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

    }elsif($q->url_param("mode2") eq "modify_member"){
	##Modify member###########

	try{
	    Affelio::App::Admin::ManageFriend::modify_member($af, $q->url_param("uid"), $q);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

	$TMPL_FILE = "$af->{site__fs_root}/templates/" .
            "$af->{site__template}/owner_side/admin_managefriends_showmember.tmpl";
	try{
	    Affelio::App::Admin::ManageFriend::show_member($af, $q->url_param("uid"), \%output_data);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

    }elsif($q->url_param("mode2") eq "unsubscribe_group"){
	##Unsubscribe group#######

	try{
	    Affelio::App::Admin::ManageFriend::unsubscribe_group($af, $q->url_param("gid"), $q->url_param("uid"));
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

	$TMPL_FILE = "$af->{site__fs_root}/templates/" .
            "$af->{site__template}/owner_side/admin_managefriends_showmember.tmpl";
	
	try{
	    Affelio::App::Admin::ManageFriend::show_member($af, $q->url_param("uid"), \%output_data);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

    }elsif($q->url_param("mode2") eq "subscribe_group"){
	##Subscribe group#########
	my @add_group_inputs = $q->param("add_group");
	foreach my $i (@add_group_inputs){
	    try{
		Affelio::App::Admin::ManageFriend::subscribe_group($af, $i, $q->url_param("uid"));
	    }catch Error with{
		my $e = shift;    $err_msg .= $e->stacktrace;
	    };
	}

	$TMPL_FILE = "$af->{site__fs_root}/templates/" .
            "$af->{site__template}/owner_side/admin_managefriends_showmember.tmpl";
	try{
	    Affelio::App::Admin::ManageFriend::show_member($af, $q->url_param("uid"), \%output_data);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

    }else{
	##TOP#####################

	$TMPL_FILE = "$af->{site__fs_root}/templates/" .
	    "$af->{site__template}/owner_side/admin_managefriends_top.tmpl";

	try{
	    Affelio::App::Admin::ManageFriend::manage_top($af, \%output_data);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

    }

#####################################################################
#Manage Groups
#####################################################################
}elsif($admin_mode eq "manage_groups"){

    use Affelio::App::Admin::ManageGroup;

    debug_print("admin.cgi: mode2=[" . $q->url_param("mode2"));
    if($q->url_param("mode2") eq "show_group"){
	##Show member#############

        $TMPL_FILE = "$af->{site__fs_root}/templates/" .
            "$af->{site__template}/owner_side/admin_managegroups_showgroup.tmpl";
	try{
	    Affelio::App::Admin::ManageGroup::show_group($af, $q->url_param("gid"), \%output_data);
      	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

    }elsif($q->url_param("mode2") eq "rename"){
	##Modify member###########
	try{
	    Affelio::App::Admin::ManageGroup::rename_group($af, $q->url_param("gid"), $q->param("new_name"));
      	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

	$TMPL_FILE = "$af->{site__fs_root}/templates/" .
	    "$af->{site__template}/owner_side/admin_managegroups_top.tmpl";

	try{
	    Affelio::App::Admin::ManageGroup::manage_top($af, \%output_data);
      	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

    }elsif($q->url_param("mode2") eq "add_group"){
	try{
	    Affelio::App::Admin::ManageGroup::add_group($af, $q->param("new_group_name"));
      	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

	$TMPL_FILE = "$af->{site__fs_root}/templates/" .
	    "$af->{site__template}/owner_side/admin_managegroups_top.tmpl";

	try{
	    Affelio::App::Admin::ManageGroup::manage_top($af, \%output_data);
      	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};
    }elsif($q->url_param("mode2") eq "remove_group"){
	try{
	    Affelio::App::Admin::ManageGroup::remove_group($af, $q->url_param("gid"), $q);
      	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

	$TMPL_FILE = "$af->{site__fs_root}/templates/" .
	    "$af->{site__template}/owner_side/admin_managegroups_top.tmpl";
	try{
	    Affelio::App::Admin::ManageGroup::manage_top($af, \%output_data);
      	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};


    }else{
	##TOP#####################

	$TMPL_FILE = "$af->{site__fs_root}/templates/" .
	    "$af->{site__template}/owner_side/admin_managegroups_top.tmpl";
	try{
	    Affelio::App::Admin::ManageGroup::manage_top($af, \%output_data);
      	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};
    }

#####################################################################
#Access Control
#####################################################################
}elsif($admin_mode eq "access_control"){
    
    use Affelio::App::Admin::AccessControl;
    
    if($q->url_param("mode2") eq "submit"){
	try{
	    save_GroupAttribute_table($af, $q);
      	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};
    }
    
    $TMPL_FILE = "$af->{site__fs_root}/templates/" .
	"$af->{site__template}/owner_side/admin_accesscontrol.tmpl";

    try{
	show_GroupAttribute_table($af, \%output_data);
    }catch Error with{
	my $e = shift;    $err_msg .= $e->stacktrace;
    };

#####################################################################
#Application Access Control
#####################################################################
}elsif($admin_mode eq "access_control_apps"){

    use Affelio::App::Admin::ManageApplication;

    if($q->url_param("mode2") eq "modify_app"){
	##Show app#############

	try{
	    Affelio::App::Admin::ManageApplication::save_permission($af, $q, $q->url_param("app_name"));
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

        $TMPL_FILE = "$af->{site__fs_root}/templates/" .
            "$af->{site__template}/owner_side/admin_accesscontrol_apps_showapp.tmpl";
	try{
	    Affelio::App::Admin::ManageApplication::show_app($af, $q->url_param("app_name"), \%output_data);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

    }elsif($q->url_param("mode2") eq "show_app"){
	##Show app#############

        $TMPL_FILE = "$af->{site__fs_root}/templates/" .
            "$af->{site__template}/owner_side/admin_accesscontrol_apps_showapp.tmpl";
	try{
	    Affelio::App::Admin::ManageApplication::show_app($af, $q->url_param("app_name"), \%output_data);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};

    }else{
	##TOP#####################

	$TMPL_FILE = "$af->{site__fs_root}/templates/" .
	    "$af->{site__template}/owner_side/admin_accesscontrol_apps_top.tmpl";

	try{
	    Affelio::App::Admin::ManageApplication::manage_top($af, \%output_data);
	}catch Error with{
	    my $e = shift;    $err_msg .= $e->stacktrace;
	};
    }


#####################################################################
#Send Invitation
#####################################################################
}elsif($admin_mode eq "send_invitation"){

    use Affelio::App::Admin::SendInvitation;
    try{
	send_invitation($af, $q->param("dest_address"), \%output_data);
    }catch Error with{
	my $e = shift;    $err_msg .= $e->stacktrace;
    };

    $TMPL_FILE = "$af->{site__fs_root}/templates/" .
	         "$af->{site__template}/owner_side/admin_top.tmpl";


#####################################################################
#Send Handshake
#####################################################################
}elsif($admin_mode eq "send_handshake"){

    use Affelio::App::Admin::SendHandshake;
    try{
	Affelio::App::Admin::SendHandshake::send($af, $q, \%output_data);
    }catch Error with{
	my $e = shift;
	$err_msg='<AF_M text="Error in handshaking"><BR>' . $e;
    };

    $TMPL_FILE = "$af->{site__fs_root}/templates/" .
	"$af->{site__template}/owner_side/handshake_sent.tmpl";

#####################################################################
#MyStatus
#####################################################################
}elsif($admin_mode eq "post_mystatus"){

    use Affelio::App::Admin::MyStatus;

    try{
	Affelio::App::Admin::MyStatus::post($af, $q->param("my_currentstatus"));
    }catch Error with{
	my $e = shift;    $err_msg .= $e->stacktrace;
    };

    $HTTP_forward_flag = 1;
    $forward_URL = "$af->{site__web_root}/admin.cgi";


#####################################################################
#Top
#####################################################################
}else{

    $TMPL_FILE = "$af->{site__fs_root}/templates/" .
	         "$af->{site__template}/owner_side/admin_top.tmpl";

    use Affelio::App::Admin::AffelioNews;
    try{
	Affelio::App::Admin::AffelioNews::getnews($af, \%output_data);
    }catch Error with{
	my $e = shift;    $err_msg .= $e->stacktrace;
    };

}#if


############################################################################
#Output View
############################################################################
if( $HTTP_forward_flag==1 ){
    print "Location: $forward_URL", "\n\n";

}else{
    print "Content-type: text/html; charset=UTF-8\n";
    print "Pragma: no-cache", "\n\n";
    print get_HTML_header();

    my $tmpl = new HTML::Template( filename => $TMPL_FILE,
				   die_on_bad_params => 0);
    foreach my $data_key (keys(%output_data)) {
	$tmpl->param($data_key => $output_data{$data_key});
	#debug_print("$data_key ... $output_data{$data_key}");
    } 
    $tmpl->param("err_msg" => $err_msg);
    $tmpl->param("ret_msg" => $ret_msg);
    $tmpl->param("site__locale" => $af->{site__locale});

    print $af->translate_templateL10N($tmpl->output);

    print get_HTML_footer();
}



####################
#Hmmmmmm
####################

    ######################################################################
    #Get_HTML_header
    ######################################################################
    sub get_HTML_header{
        my $self = shift;
        my $app__page_title = shift;

#        my $af = $self->{af};

        #Set template file name
        my $TMPL_FILE = "$af->{site__fs_root}/templates_dyn/_header.tmpl";
        #Set data for template
        my %output_data = ();
        $output_data{'app__css_path'} = $af->{site__web_root}."/templates/default/owner_side";
        $output_data{'app__page_title'} = "Affelio Owner's page";
        $output_data{"site__skin_dir"} = $af->{site__web_root} . "/skins/" . $af->{userpref__skin};
        $output_data{'site__web_root'} = $af->{site__web_root};
        $output_data{'site__locale'} = $af->{site__locale};

        $af->get_module_list(\%output_data, $af->{site__web_root},"self");
        $af->get_guest_owner_list(\%output_data);

        #Initiate Template
        my $tmpl = new HTML::Template( filename => $TMPL_FILE,
                                       die_on_bad_params => 0);
        foreach my $data_key (keys(%output_data)) {
            debug_print("$data_key = $output_data{$data_key}");
            $tmpl->param($data_key => $output_data{$data_key});
        }

        my $final_out = $af->translate_templateL10N($tmpl->output)
            . '<div class="afMain">' . "\n";

        return($final_out);

    }
    
    ######################################################################
    #get_HTML_footer
    ######################################################################
    sub get_HTML_footer{
        my $self = shift;
#        my $af = $self->{af};

        #Set template file name
        my $TMPL_FILE = "$af->{site__fs_root}/templates_dyn/_footer.tmpl";
        my $tmpl = new HTML::Template(filename => $TMPL_FILE);

        my $final_out = "</div><!--afPubMain-->"
            . $af->translate_templateL10N($tmpl->output);

        return($final_out);
    }
    


    
