/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.jms.ResourceAllocationException;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.BaseDestination;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.DurableTopicSubscription;
import org.apache.activemq.broker.region.LockOwner;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.policy.DispatchPolicy;
import org.apache.activemq.broker.region.policy.FixedSizedSubscriptionRecoveryPolicy;
import org.apache.activemq.broker.region.policy.NoSubscriptionRecoveryPolicy;
import org.apache.activemq.broker.region.policy.SimpleDispatchPolicy;
import org.apache.activemq.broker.region.policy.SubscriptionRecoveryPolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerAck;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.filter.NonCachedMessageEvaluationContext;
import org.apache.activemq.state.ProducerState;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.thread.Valve;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.util.SubscriptionKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Topic
extends BaseDestination
implements Task {
    protected static final Log LOG = LogFactory.getLog(Topic.class);
    private final TopicMessageStore topicStore;
    protected final CopyOnWriteArrayList<Subscription> consumers = new CopyOnWriteArrayList();
    protected final Valve dispatchValve = new Valve(true);
    private DispatchPolicy dispatchPolicy = new SimpleDispatchPolicy();
    private SubscriptionRecoveryPolicy subscriptionRecoveryPolicy;
    private boolean sendAdvisoryIfNoConsumers;
    private final ConcurrentHashMap<SubscriptionKey, DurableTopicSubscription> durableSubcribers = new ConcurrentHashMap();
    private final TaskRunner taskRunner;
    private final LinkedList<Runnable> messagesWaitingForSpace = new LinkedList();
    private final Runnable sendMessagesWaitingForSpaceTask = new Runnable(){

        public void run() {
            try {
                Topic.this.taskRunner.wakeup();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    public Topic(BrokerService brokerService, ActiveMQDestination destination, TopicMessageStore store, DestinationStatistics parentStats, TaskRunnerFactory taskFactory) throws Exception {
        super(brokerService, store, destination, parentStats);
        this.topicStore = store;
        this.subscriptionRecoveryPolicy = destination.isTemporary() || AdvisorySupport.isAdvisoryTopic(destination) ? new NoSubscriptionRecoveryPolicy() : new FixedSizedSubscriptionRecoveryPolicy();
        this.taskRunner = taskFactory.createTaskRunner(this, "Topic  " + destination.getPhysicalName());
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        if (this.store != null) {
            int messageCount = this.store.getMessageCount();
            this.destinationStatistics.getMessages().setCount(messageCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Subscription> getConsumers() {
        CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
        synchronized (copyOnWriteArrayList) {
            return new ArrayList<Subscription>(this.consumers);
        }
    }

    public boolean lock(MessageReference node, LockOwner sub) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        sub.add(context, this);
        this.destinationStatistics.getConsumers().increment();
        if (!sub.getConsumerInfo().isDurable()) {
            if (sub.getConsumerInfo().isRetroactive()) {
                this.dispatchValve.turnOff();
                try {
                    CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
                    synchronized (copyOnWriteArrayList) {
                        this.consumers.add(sub);
                    }
                    this.subscriptionRecoveryPolicy.recover(context, this, sub);
                }
                finally {
                    this.dispatchValve.turnOn();
                }
            }
            CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
            synchronized (copyOnWriteArrayList) {
                this.consumers.add(sub);
            }
        }
        DurableTopicSubscription dsub = (DurableTopicSubscription)sub;
        this.durableSubcribers.put(dsub.getSubscriptionKey(), dsub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscription(ConnectionContext context, Subscription sub) throws Exception {
        if (!sub.getConsumerInfo().isDurable()) {
            this.destinationStatistics.getConsumers().decrement();
            CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
            synchronized (copyOnWriteArrayList) {
                this.consumers.remove(sub);
            }
        }
        sub.remove(context, this);
    }

    public void deleteSubscription(ConnectionContext context, SubscriptionKey key) throws IOException {
        if (this.topicStore != null) {
            this.topicStore.deleteSubscription(key.clientId, key.subscriptionName);
            DurableTopicSubscription removed = this.durableSubcribers.remove(key);
            if (removed != null) {
                this.destinationStatistics.getConsumers().decrement();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(ConnectionContext context, final DurableTopicSubscription subscription) throws Exception {
        this.dispatchValve.turnOff();
        try {
            String s1;
            CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
            synchronized (copyOnWriteArrayList) {
                this.consumers.add(subscription);
            }
            if (this.topicStore == null) {
                return;
            }
            String clientId = subscription.getSubscriptionKey().getClientId();
            String subscriptionName = subscription.getSubscriptionKey().getSubscriptionName();
            String selector = subscription.getConsumerInfo().getSelector();
            SubscriptionInfo info = this.topicStore.lookupSubscription(clientId, subscriptionName);
            if (info != null && ((s1 = info.getSelector()) == null ^ selector == null || s1 != null && !s1.equals(selector))) {
                this.topicStore.deleteSubscription(clientId, subscriptionName);
                info = null;
            }
            if (info == null) {
                info = new SubscriptionInfo();
                info.setClientId(clientId);
                info.setSelector(selector);
                info.setSubscriptionName(subscriptionName);
                info.setDestination(this.getActiveMQDestination());
                info.setSubscribedDestination(subscription.getConsumerInfo().getDestination());
                this.topicStore.addSubsciption(info, subscription.getConsumerInfo().isRetroactive());
            }
            final NonCachedMessageEvaluationContext msgContext = new NonCachedMessageEvaluationContext();
            msgContext.setDestination(this.destination);
            if (subscription.isRecoveryRequired()) {
                this.topicStore.recoverSubscription(clientId, subscriptionName, new MessageRecoveryListener(){

                    public boolean recoverMessage(Message message) throws Exception {
                        message.setRegionDestination(Topic.this);
                        try {
                            msgContext.setMessageReference(message);
                            if (subscription.matches(message, msgContext)) {
                                subscription.add(message);
                            }
                        }
                        catch (IOException e) {
                            LOG.error((Object)("Failed to recover this message " + message));
                        }
                        return true;
                    }

                    public boolean recoverMessageReference(MessageId messageReference) throws Exception {
                        throw new RuntimeException("Should not be called.");
                    }

                    public boolean hasSpace() {
                        return true;
                    }
                });
            }
        }
        finally {
            this.dispatchValve.turnOn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(ConnectionContext context, DurableTopicSubscription sub) throws Exception {
        CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
        synchronized (copyOnWriteArrayList) {
            this.consumers.remove(sub);
        }
        sub.remove(context, this);
    }

    protected void recoverRetroactiveMessages(ConnectionContext context, Subscription subscription) throws Exception {
        if (subscription.getConsumerInfo().isRetroactive()) {
            this.subscriptionRecoveryPolicy.recover(context, this, subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(final ProducerBrokerExchange producerExchange, final Message message) throws Exception {
        boolean sendProducerAck;
        final ConnectionContext context = producerExchange.getConnectionContext();
        final ProducerInfo producerInfo = producerExchange.getProducerState().getInfo();
        boolean bl = sendProducerAck = !message.isResponseRequired() && producerInfo.getWindowSize() > 0 && !context.isInRecoveryMode();
        if (message.isExpired()) {
            this.broker.messageExpired(context, message);
            if (sendProducerAck) {
                ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
                context.getConnection().dispatchAsync(ack);
            }
            return;
        }
        if (this.memoryUsage.isFull()) {
            this.isFull(context, this.memoryUsage);
            this.fastProducer(context, producerInfo);
            if (this.isProducerFlowControl() && context.isProducerFlowControl()) {
                if (this.systemUsage.isSendFailIfNoSpace()) {
                    throw new ResourceAllocationException("Usage Manager memory limit reached");
                }
                if (producerInfo.getWindowSize() > 0 || message.isResponseRequired()) {
                    LinkedList<Runnable> ack = this.messagesWaitingForSpace;
                    synchronized (ack) {
                        this.messagesWaitingForSpace.add(new Runnable(){

                            public void run() {
                                block6: {
                                    try {
                                        if (message.isExpired()) {
                                            Topic.this.broker.messageExpired(context, message);
                                        } else {
                                            Topic.this.doMessageSend(producerExchange, message);
                                        }
                                        if (sendProducerAck) {
                                            ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
                                            context.getConnection().dispatchAsync(ack);
                                        } else {
                                            Response response = new Response();
                                            response.setCorrelationId(message.getCommandId());
                                            context.getConnection().dispatchAsync(response);
                                        }
                                    }
                                    catch (Exception e) {
                                        if (sendProducerAck || context.isInRecoveryMode()) break block6;
                                        ExceptionResponse response = new ExceptionResponse(e);
                                        response.setCorrelationId(message.getCommandId());
                                        context.getConnection().dispatchAsync(response);
                                    }
                                }
                            }
                        });
                        if (!this.memoryUsage.notifyCallbackWhenNotFull(this.sendMessagesWaitingForSpaceTask)) {
                            this.sendMessagesWaitingForSpaceTask.run();
                        }
                        context.setDontSendReponse(true);
                        return;
                    }
                }
                int count = 0;
                while (!this.memoryUsage.waitForSpace(1000L)) {
                    if (context.getStopping().get()) {
                        throw new IOException("Connection closed, send aborted.");
                    }
                    if (count <= 2 || !context.isInTransaction()) continue;
                    count = 0;
                    int size = context.getTransaction().size();
                    LOG.warn((Object)("Waiting for space to send  transacted message - transaction elements = " + size + " need more space to commit. Message = " + message));
                }
                if (message.isExpired()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Expired message: " + message));
                    }
                    return;
                }
            }
        }
        this.doMessageSend(producerExchange, message);
        this.messageDelivered(context, message);
        if (sendProducerAck) {
            ProducerAck ack = new ProducerAck(producerInfo.getProducerId(), message.getSize());
            context.getConnection().dispatchAsync(ack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doMessageSend(ProducerBrokerExchange producerExchange, final Message message) throws IOException, Exception {
        final ConnectionContext context = producerExchange.getConnectionContext();
        message.setRegionDestination(this);
        message.getMessageId().setBrokerSequenceId(this.getDestinationSequenceId());
        if (this.topicStore != null && message.isPersistent() && !this.canOptimizeOutPersistence()) {
            if (this.isProducerFlowControl() && context.isProducerFlowControl() && this.systemUsage.isSendFailIfNoSpace() && this.systemUsage.getStoreUsage().isFull()) {
                throw new ResourceAllocationException("Usage Manager Store is Full");
            }
            while (!this.systemUsage.getStoreUsage().waitForSpace(1000L)) {
                if (!context.getStopping().get()) continue;
                throw new IOException("Connection closed, send aborted.");
            }
            this.topicStore.addMessage(context, message);
        }
        message.incrementReferenceCount();
        if (context.isInTransaction()) {
            context.getTransaction().addSynchronization(new Synchronization(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterCommit() throws Exception {
                    if (Topic.this.broker.isExpired(message)) {
                        Topic.this.broker.messageExpired(context, message);
                        message.decrementReferenceCount();
                        return;
                    }
                    try {
                        Topic.this.dispatch(context, message);
                    }
                    finally {
                        message.decrementReferenceCount();
                    }
                }
            });
        } else {
            try {
                this.dispatch(context, message);
            }
            finally {
                message.decrementReferenceCount();
            }
        }
    }

    private boolean canOptimizeOutPersistence() {
        return this.durableSubcribers.size() == 0;
    }

    public String toString() {
        return "Topic: destination=" + this.destination.getPhysicalName() + ", subscriptions=" + this.consumers.size();
    }

    @Override
    public void acknowledge(ConnectionContext context, Subscription sub, MessageAck ack, MessageReference node) throws IOException {
        if (this.topicStore != null && node.isPersistent()) {
            DurableTopicSubscription dsub = (DurableTopicSubscription)sub;
            SubscriptionKey key = dsub.getSubscriptionKey();
            this.topicStore.acknowledge(context, key.getClientId(), key.getSubscriptionName(), node.getMessageId());
        }
        this.messageConsumed(context, node);
    }

    @Override
    public void dispose(ConnectionContext context) throws IOException {
        super.dispose(context);
        if (this.topicStore != null) {
            this.topicStore.removeAllMessages(context);
        }
    }

    @Override
    public void gc() {
    }

    public Message loadMessage(MessageId messageId) throws IOException {
        return this.topicStore != null ? this.topicStore.getMessage(messageId) : null;
    }

    @Override
    public void start() throws Exception {
        this.subscriptionRecoveryPolicy.start();
        if (this.memoryUsage != null) {
            this.memoryUsage.start();
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.taskRunner != null) {
            this.taskRunner.shutdown();
        }
        this.subscriptionRecoveryPolicy.stop();
        if (this.memoryUsage != null) {
            this.memoryUsage.stop();
        }
    }

    @Override
    public Message[] browse() {
        final CopyOnWriteArraySet<Message> result = new CopyOnWriteArraySet<Message>();
        try {
            if (this.topicStore != null) {
                this.topicStore.recover(new MessageRecoveryListener(){

                    public boolean recoverMessage(Message message) throws Exception {
                        result.add(message);
                        return true;
                    }

                    public boolean recoverMessageReference(MessageId messageReference) throws Exception {
                        return true;
                    }

                    public boolean hasSpace() {
                        return true;
                    }
                });
                Message[] msgs = this.subscriptionRecoveryPolicy.browse(this.getActiveMQDestination());
                if (msgs != null) {
                    for (int i = 0; i < msgs.length; ++i) {
                        result.add(msgs[i]);
                    }
                }
            }
        }
        catch (Throwable e) {
            LOG.warn((Object)("Failed to browse Topic: " + this.getActiveMQDestination().getPhysicalName()), e);
        }
        return result.toArray(new Message[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean iterate() {
        LinkedList<Runnable> linkedList = this.messagesWaitingForSpace;
        synchronized (linkedList) {
            while (!this.memoryUsage.isFull() && !this.messagesWaitingForSpace.isEmpty()) {
                Runnable op = this.messagesWaitingForSpace.removeFirst();
                op.run();
            }
        }
        return false;
    }

    public DispatchPolicy getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public void setDispatchPolicy(DispatchPolicy dispatchPolicy) {
        this.dispatchPolicy = dispatchPolicy;
    }

    public SubscriptionRecoveryPolicy getSubscriptionRecoveryPolicy() {
        return this.subscriptionRecoveryPolicy;
    }

    public void setSubscriptionRecoveryPolicy(SubscriptionRecoveryPolicy subscriptionRecoveryPolicy) {
        this.subscriptionRecoveryPolicy = subscriptionRecoveryPolicy;
    }

    public boolean isSendAdvisoryIfNoConsumers() {
        return this.sendAdvisoryIfNoConsumers;
    }

    public void setSendAdvisoryIfNoConsumers(boolean sendAdvisoryIfNoConsumers) {
        this.sendAdvisoryIfNoConsumers = sendAdvisoryIfNoConsumers;
    }

    @Override
    public final void wakeup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dispatch(ConnectionContext context, Message message) throws Exception {
        this.destinationStatistics.getMessages().increment();
        this.destinationStatistics.getEnqueues().increment();
        this.dispatchValve.increment();
        MessageEvaluationContext msgContext = null;
        try {
            if (!this.subscriptionRecoveryPolicy.add(context, message)) {
                return;
            }
            CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.consumers;
            synchronized (copyOnWriteArrayList) {
                if (this.consumers.isEmpty()) {
                    this.onMessageWithNoConsumers(context, message);
                    return;
                }
            }
            msgContext = context.getMessageEvaluationContext();
            msgContext.setDestination(this.destination);
            msgContext.setMessageReference(message);
            if (this.dispatchPolicy.dispatch(message, msgContext, this.consumers)) return;
            this.onMessageWithNoConsumers(context, message);
            return;
        }
        finally {
            this.dispatchValve.decrement();
            if (msgContext != null) {
                msgContext.clear();
            }
        }
    }

    @Override
    public void messageExpired(ConnectionContext context, Subscription subs, MessageReference reference) {
        this.broker.messageExpired(context, reference);
        this.destinationStatistics.getMessages().decrement();
        this.destinationStatistics.getEnqueues().decrement();
        MessageAck ack = new MessageAck();
        ack.setAckType((byte)2);
        ack.setDestination(this.destination);
        ack.setMessageID(reference.getMessageId());
        try {
            this.acknowledge(context, subs, ack, reference);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to remove expired Message from the store ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMessageWithNoConsumers(ConnectionContext context, Message message) throws Exception {
        if (!message.isPersistent() && this.sendAdvisoryIfNoConsumers && !AdvisorySupport.isAdvisoryTopic(this.destination)) {
            if (message.getOriginalDestination() != null) {
                message.setOriginalDestination(message.getDestination());
            }
            if (message.getOriginalTransactionId() != null) {
                message.setOriginalTransactionId(message.getTransactionId());
            }
            ActiveMQTopic advisoryTopic = AdvisorySupport.getNoTopicConsumersAdvisoryTopic(this.destination);
            message.setDestination(advisoryTopic);
            message.setTransactionId(null);
            boolean originalFlowControl = context.isProducerFlowControl();
            try {
                context.setProducerFlowControl(false);
                ProducerBrokerExchange producerExchange = new ProducerBrokerExchange();
                producerExchange.setMutable(false);
                producerExchange.setConnectionContext(context);
                producerExchange.setProducerState(new ProducerState(new ProducerInfo()));
                context.getBroker().send(producerExchange, message);
            }
            finally {
                context.setProducerFlowControl(originalFlowControl);
            }
        }
    }
}

