/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.web.WebClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class MessageServletSupport
extends HttpServlet {
    private static final transient Log LOG = LogFactory.getLog(MessageServletSupport.class);
    private boolean defaultTopicFlag = true;
    private Destination defaultDestination;
    private String destinationParameter = "destination";
    private String typeParameter = "type";
    private String bodyParameter = "body";
    private boolean defaultMessagePersistent = true;
    private int defaultMessagePriority = 5;
    private long defaultMessageTimeToLive;
    private String destinationOptions;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.destinationOptions = servletConfig.getInitParameter("destinationOptions");
        String name = servletConfig.getInitParameter("topic");
        if (name != null) {
            this.defaultTopicFlag = MessageServletSupport.asBoolean(name);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Defaulting to use topics: " + this.defaultTopicFlag));
        }
        if ((name = servletConfig.getInitParameter("destination")) != null) {
            this.defaultDestination = this.defaultTopicFlag ? new ActiveMQTopic(name) : new ActiveMQQueue(name);
        }
        WebClient.initContext(this.getServletContext());
    }

    public static boolean asBoolean(String param) {
        return MessageServletSupport.asBoolean(param, false);
    }

    public static boolean asBoolean(String param, boolean defaultValue) {
        if (param == null) {
            return defaultValue;
        }
        return param.equalsIgnoreCase("true");
    }

    protected void appendParametersToMessage(HttpServletRequest request, TextMessage message) throws JMSException {
        Destination replyTo;
        Long expiration;
        Map parameterMap = request.getParameterMap();
        if (parameterMap == null) {
            return;
        }
        HashMap parameters = new HashMap(parameterMap);
        String correlationID = this.asString(parameters.remove("JMSCorrelationID"));
        if (correlationID != null) {
            message.setJMSCorrelationID(correlationID);
        }
        if ((expiration = this.asLong(parameters.remove("JMSExpiration"))) != null) {
            message.setJMSExpiration(expiration.longValue());
        }
        if ((replyTo = this.asDestination(parameters.remove("JMSReplyTo"))) != null) {
            message.setJMSReplyTo(replyTo);
        }
        String type = this.asString(parameters.remove("JMSType"));
        if (correlationID != null) {
            message.setJMSType(type);
        }
        for (Map.Entry entry : parameters.entrySet()) {
            String name = (String)entry.getKey();
            if (this.destinationParameter.equals(name) || this.typeParameter.equals(name) || this.bodyParameter.equals(name) || "JMSDeliveryMode".equals(name) || "JMSPriority".equals(name) || "JMSTimeToLive".equals(name)) continue;
            Object value = entry.getValue();
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                if (array.length == 1) {
                    value = array[0];
                } else {
                    LOG.warn((Object)("Can't use property: " + name + " which is of type: " + value.getClass().getName() + " value"));
                    value = null;
                    int size = array.length;
                    for (int i = 0; i < size; ++i) {
                        LOG.debug((Object)("value[" + i + "] = " + array[i]));
                    }
                }
            }
            if (value == null) continue;
            message.setObjectProperty(name, value);
        }
    }

    protected long getSendTimeToLive(HttpServletRequest request) {
        String text = request.getParameter("JMSTimeToLive");
        if (text != null) {
            return this.asLong(text);
        }
        return this.defaultMessageTimeToLive;
    }

    protected int getSendPriority(HttpServletRequest request) {
        String text = request.getParameter("JMSPriority");
        if (text != null) {
            return this.asInt(text);
        }
        return this.defaultMessagePriority;
    }

    protected boolean isSendPersistent(HttpServletRequest request) {
        String text = request.getParameter("JMSDeliveryMode");
        if (text != null) {
            return text.trim().equalsIgnoreCase("persistent");
        }
        return this.defaultMessagePersistent;
    }

    protected boolean isSync(HttpServletRequest request) {
        String text = request.getParameter("sync");
        return text != null;
    }

    protected Destination asDestination(Object value) {
        if (value instanceof Destination) {
            return (Destination)value;
        }
        if (value instanceof String) {
            String text = (String)value;
            return ActiveMQDestination.createDestination((String)text, (byte)1);
        }
        if (value instanceof String[]) {
            String text = ((String[])value)[0];
            if (text == null) {
                return null;
            }
            return ActiveMQDestination.createDestination((String)text, (byte)1);
        }
        return null;
    }

    protected Integer asInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        if (value instanceof String[]) {
            return Integer.valueOf(((String[])value)[0]);
        }
        return null;
    }

    protected Long asLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        if (value instanceof String[]) {
            return Long.valueOf(((String[])value)[0]);
        }
        return null;
    }

    protected long asLong(String name) {
        return Long.parseLong(name);
    }

    protected int asInt(String name) {
        return Integer.parseInt(name);
    }

    protected String asString(Object value) {
        if (value instanceof String[]) {
            return ((String[])value)[0];
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    protected Destination getDestination(WebClient client, HttpServletRequest request) throws JMSException {
        String destinationName = request.getParameter(this.destinationParameter);
        if (destinationName == null || destinationName.equals("")) {
            if (this.defaultDestination == null) {
                return this.getDestinationFromURI(client, request);
            }
            return this.defaultDestination;
        }
        return this.getDestination(client, request, destinationName);
    }

    protected Destination getDestinationFromURI(WebClient client, HttpServletRequest request) throws JMSException {
        String uri = request.getPathInfo();
        if (uri == null) {
            return null;
        }
        if (uri.startsWith("/") && (uri = uri.substring(1)).length() == 0) {
            return null;
        }
        uri = uri.replace('/', '.');
        LOG.debug((Object)("destination uri=" + uri));
        return this.getDestination(client, request, uri);
    }

    protected Destination getDestination(WebClient client, HttpServletRequest request, String destinationName) throws JMSException {
        boolean isTopic = this.defaultTopicFlag;
        if (destinationName.startsWith("topic://")) {
            isTopic = true;
            destinationName = destinationName.substring(8);
        } else if (destinationName.startsWith("channel://")) {
            isTopic = false;
            destinationName = destinationName.substring(10);
        } else {
            isTopic = this.isTopic(request);
        }
        if (this.destinationOptions != null) {
            destinationName = destinationName + "?" + this.destinationOptions;
        }
        LOG.debug((Object)(destinationName + " (" + (isTopic ? "topic" : "queue") + ")"));
        if (isTopic) {
            return client.getSession().createTopic(destinationName);
        }
        return client.getSession().createQueue(destinationName);
    }

    protected boolean isTopic(HttpServletRequest request) {
        String typeText = request.getParameter(this.typeParameter);
        if (typeText == null) {
            return this.defaultTopicFlag;
        }
        return typeText.equalsIgnoreCase("topic");
    }

    protected String getPostedMessageBody(HttpServletRequest request) throws IOException {
        String answer = request.getParameter(this.bodyParameter);
        if (answer == null && "text/xml".equals(request.getContentType())) {
            String line;
            BufferedReader reader = request.getReader();
            StringBuffer buffer = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append("\n");
            }
            return buffer.toString();
        }
        return answer;
    }
}

