/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.localstore;

import com.qbrowser.QBrowserV2;
import com.qbrowser.localstore.LocalMessageContainer;
import com.qbrowser.localstore.LocalStoreDef;
import com.qbrowser.localstore.LocalStoreProperty;
import com.qbrowser.persist.BytesMessagePersister;
import com.qbrowser.persist.MapMessagePersister;
import com.qbrowser.persist.MessagePersister;
import com.qbrowser.persist.ObjectMessagePersister;
import com.qbrowser.persist.StreamMessagePersister;
import com.qbrowser.persist.TextMessagePersister;
import com.qbrowser.util.QBrowserUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.swing.JDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalStoreManager {
    LocalStoreDef lsd;
    static HashMap local_store_index = new HashMap();
    static ResourceBundle resources = QBrowserV2.resources;
    static HashMap destName_LocalSubscriptionDest = new HashMap();
    static String saved_def_name;

    public LocalStoreManager(String id) {
        local_store_index = new HashMap();
        destName_LocalSubscriptionDest = new HashMap();
        this.lsd = new LocalStoreDef();
        saved_def_name = QBrowserUtil.getQBrowserTempFileDir() + "localstoredef" + id;
        File lsdef = new File(saved_def_name);
        if (!lsdef.exists()) {
            File qvd = new File(QBrowserUtil.getQBrowserTempFileDir());
            if (!qvd.exists()) {
                qvd.mkdirs();
            }
            LocalStoreProperty lsp1 = new LocalStoreProperty();
            lsp1.setDestName("TMPWORK");
            lsp1.setReal_file_directory(QBrowserUtil.getQBrowserTempFileDir() + "tmpwork_localstore");
            lsp1.setValid(true);
            this.lsd.setLocalStoreProperty(lsp1);
            this.lsd.save(new File(saved_def_name));
        } else {
            this.lsd.readAndParseLocalStoreDefFile(lsdef, destName_LocalSubscriptionDest);
        }
    }

    public static void addMsgIndex(String puredest, String msgid, String msg_filepath) {
        HashMap<String, String> msgid_filepath = (HashMap<String, String>)local_store_index.get(puredest);
        if (msgid_filepath == null) {
            msgid_filepath = new HashMap<String, String>();
        }
        msgid_filepath.put(msgid, msg_filepath);
        local_store_index.put(puredest, msgid_filepath);
    }

    public void removeMsgIndex(String puredest, String msgid) {
        HashMap msgid_filepath = (HashMap)local_store_index.get(puredest);
        if (msgid_filepath != null) {
            msgid_filepath.remove(msgid);
        }
    }

    public String getMsgFilePath(String puredest, String msgid) {
        HashMap msgid_filepath = (HashMap)local_store_index.get(puredest);
        if (msgid_filepath != null) {
            String filepath = (String)msgid_filepath.get(msgid);
            return filepath;
        }
        return null;
    }

    public ArrayList<String> getAllLocalStoreNames() {
        Collection<LocalStoreProperty> col1 = this.lsd.getAllLocalStoreProperties();
        Iterator<LocalStoreProperty> icol1 = col1.iterator();
        ArrayList<String> retval = new ArrayList<String>();
        while (icol1.hasNext()) {
            LocalStoreProperty lsp = icol1.next();
            retval.add(lsp.getDestName());
        }
        Collections.sort(retval);
        return retval;
    }

    public ArrayList<String> getAllValidLocalStoreNames() {
        Collection<LocalStoreProperty> col1 = this.lsd.getAllLocalStoreProperties();
        Iterator<LocalStoreProperty> icol1 = col1.iterator();
        ArrayList<String> retval = new ArrayList<String>();
        while (icol1.hasNext()) {
            LocalStoreProperty lsp = icol1.next();
            if (!lsp.isValid()) continue;
            retval.add(lsp.getDestName());
        }
        Collections.sort(retval);
        return retval;
    }

    public Collection<LocalStoreProperty> listLocalStoreProperties() {
        return this.lsd.getAllLocalStoreProperties();
    }

    public LocalStoreProperty getLocalStoreProperty(String local_dest_without_suffix) {
        return this.lsd.getLocalStoreProperty(local_dest_without_suffix);
    }

    public LocalStore getLocalStoreInstance(String local_dest_without_suffix) {
        LocalStoreProperty lsp = this.lsd.getLocalStoreProperty(local_dest_without_suffix);
        try {
            return new LocalStore(lsp);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void addLocalStoreProperty(LocalStoreProperty lsp) {
        this.lsd.setLocalStoreProperty(lsp);
    }

    public ArrayList<String> getCopyToListOfTheDestination(String dest_name_with_suffix) {
        HashMap local_and_selector = (HashMap)destName_LocalSubscriptionDest.get(dest_name_with_suffix);
        ArrayList<String> retval = new ArrayList<String>();
        if (local_and_selector != null) {
            for (String local_dest : local_and_selector.keySet()) {
                retval.add(local_dest);
            }
        }
        return retval;
    }

    public void addDestCopySubscriptionToLocalStore(String local_store_name_without_suffix, String subscribe_dest_name_with_suffix, String selector) throws Exception {
        LocalStoreProperty lsp = this.lsd.getLocalStoreProperty(local_store_name_without_suffix);
        if (lsp == null) {
            throw new Exception("Local Store not found.");
        }
        if (lsp.getDestNameWithSuffix().equals(subscribe_dest_name_with_suffix)) {
            throw new Exception("Subscription target cannot be itself.");
        }
        HashMap<String, String> local_and_selector = (HashMap<String, String>)destName_LocalSubscriptionDest.get(subscribe_dest_name_with_suffix);
        if (local_and_selector == null) {
            local_and_selector = new HashMap<String, String>();
        }
        local_and_selector.put(local_store_name_without_suffix, selector);
        destName_LocalSubscriptionDest.put(subscribe_dest_name_with_suffix, local_and_selector);
        lsp.addFromDests(subscribe_dest_name_with_suffix, selector);
        this.lsd.setLocalStoreProperty(lsp);
        this.lsd.save(new File(saved_def_name));
    }

    public void removeRelatedEntryOfSubscribeDest(String subscribe_dest_name_with_suffix) {
        destName_LocalSubscriptionDest.remove(subscribe_dest_name_with_suffix);
    }

    public void removeDestCopySubscriptionToLocalStore(String local_store_name_without_suffix, String subscribe_dest_name_with_suffix) throws Exception {
        HashMap local_and_selector = (HashMap)destName_LocalSubscriptionDest.get(subscribe_dest_name_with_suffix);
        if (local_and_selector == null) {
            local_and_selector = new HashMap();
        }
        local_and_selector.remove(local_store_name_without_suffix);
        destName_LocalSubscriptionDest.put(subscribe_dest_name_with_suffix, local_and_selector);
    }

    public void updateAndSaveLocalStoreProperty(LocalStoreProperty lsp) throws Exception {
        if (lsp == null) {
            throw new Exception("LocalStoreProperty is not set.");
        }
        this.lsd.setLocalStoreProperty(lsp);
        this.lsd.save(new File(saved_def_name));
    }

    public void addNewLocalStoreProperty(LocalStoreProperty lsp) throws Exception {
        if (lsp == null) {
            throw new Exception("LocalStoreProperty is not set.");
        }
        LocalStoreProperty glsp = this.lsd.getLocalStoreProperty(lsp.getDestName());
        if (glsp != null) {
            throw new Exception(resources.getString("qkey.msg.msg299"));
        }
        this.lsd.setLocalStoreProperty(lsp);
        this.lsd.save(new File(saved_def_name));
    }

    public void updateLocalStoreProperty(LocalStoreProperty lsp) throws Exception {
        LocalStoreProperty target = this.lsd.getLocalStoreProperty(lsp.getDestName());
        if (target == null) {
            throw new Exception("target local store not found.");
        }
        this.lsd.setLocalStoreProperty(lsp);
    }

    public void removeLocalStoreProperty(LocalStoreProperty lsp) {
        this.lsd.removeLocalStoreProperty(lsp.getDestName());
        this.lsd.save(new File(saved_def_name));
    }

    public void deleteLocalStoreData(String msgid, String local_store_name_without_suffix) throws IOException {
        String target_file_path = this.getMsgFilePath(local_store_name_without_suffix, msgid);
        File tf = new File(target_file_path);
        tf.delete();
    }

    public void clearLocalStore(String local_store_name_without_suffix) throws IOException {
        LocalStoreProperty target = this.lsd.getLocalStoreProperty(local_store_name_without_suffix);
        File targetdir = new File(target.getReal_file_directory());
        if (targetdir != null && targetdir.exists() && targetdir.isDirectory()) {
            File[] files = targetdir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().endsWith("Message.zip")) continue;
                files[i].delete();
            }
        }
    }

    public static class LocalStore {
        static ResourceBundle resources = QBrowserV2.resources;
        LocalStoreProperty thisproperty;

        public LocalStore(LocalStoreProperty thisvalue) throws Exception {
            if (thisvalue == null) {
                throw new Exception("local store property is not set.");
            }
            this.thisproperty = thisvalue;
        }

        public File messageToFile(Message sel_message, StringBuilder sbuf, JDialog cmp) {
            File tf = null;
            File workdir = null;
            if (sel_message instanceof TextMessage) {
                TextMessagePersister mp = new TextMessagePersister((TextMessage)sel_message);
                mp.setTextBuffer(sbuf);
                mp.setMsgDialog(cmp);
                try {
                    workdir = mp.persistToFile();
                    String file_target_string = this.thisproperty.getReal_file_directory() + QBrowserUtil.eliminateDameMoji(sel_message.getJMSMessageID()) + "_TextMessage.zip";
                    tf = new File(file_target_string);
                    mp.zipUp(workdir, tf);
                    sbuf.append(resources.getString("qkey.msg.msg253"));
                    sbuf.append("\n\n");
                    return tf;
                }
                catch (Exception ex) {
                    mp.cleanupWorkDir(workdir);
                    ex.printStackTrace();
                }
            } else if (sel_message instanceof BytesMessage) {
                BytesMessagePersister mp = new BytesMessagePersister((BytesMessage)sel_message);
                mp.setTextBuffer(sbuf);
                mp.setMsgDialog(cmp);
                try {
                    workdir = mp.persistToFile();
                    String file_target_string = this.thisproperty.getReal_file_directory() + QBrowserUtil.eliminateDameMoji(sel_message.getJMSMessageID()) + "_BytesMessage.zip";
                    tf = new File(file_target_string);
                    mp.zipUp(workdir, tf);
                    sbuf.append(resources.getString("qkey.msg.msg253"));
                    sbuf.append("\n\n");
                    cmp.getRootPane().updateUI();
                    return tf;
                }
                catch (Exception ex) {
                    mp.cleanupWorkDir(workdir);
                    ex.printStackTrace();
                }
            } else if (sel_message instanceof MapMessage) {
                MapMessagePersister mp = new MapMessagePersister((MapMessage)sel_message);
                mp.setTextBuffer(sbuf);
                mp.setMsgDialog(cmp);
                try {
                    workdir = mp.persistToFile();
                    String file_target_string = this.thisproperty.getReal_file_directory() + QBrowserUtil.eliminateDameMoji(sel_message.getJMSMessageID()) + "_MapMessage.zip";
                    tf = new File(file_target_string);
                    mp.zipUp(workdir, tf);
                    sbuf.append(resources.getString("qkey.msg.msg253"));
                    sbuf.append("\n\n");
                    return tf;
                }
                catch (Exception ex) {
                    mp.cleanupWorkDir(workdir);
                    ex.printStackTrace();
                }
            } else if (sel_message instanceof StreamMessage) {
                StreamMessagePersister mp = new StreamMessagePersister((StreamMessage)sel_message);
                mp.setTextBuffer(sbuf);
                mp.setMsgDialog(cmp);
                try {
                    workdir = mp.persistToFile();
                    String file_target_string = this.thisproperty.getReal_file_directory() + QBrowserUtil.eliminateDameMoji(sel_message.getJMSMessageID()) + "_StreamMessage.zip";
                    tf = new File(file_target_string);
                    mp.zipUp(workdir, tf);
                    sbuf.append(resources.getString("qkey.msg.msg253"));
                    sbuf.append("\n\n");
                    return tf;
                }
                catch (Exception ex) {
                    mp.cleanupWorkDir(workdir);
                    ex.printStackTrace();
                }
            } else if (sel_message instanceof ObjectMessage) {
                ObjectMessagePersister mp = new ObjectMessagePersister((ObjectMessage)sel_message);
                mp.setTextBuffer(sbuf);
                mp.setMsgDialog(cmp);
                try {
                    workdir = mp.persistToFile();
                    String file_target_string = this.thisproperty.getReal_file_directory() + QBrowserUtil.eliminateDameMoji(sel_message.getJMSMessageID()) + "_ObjectMessage.zip";
                    tf = new File(file_target_string);
                    mp.zipUp(workdir, tf);
                    sbuf.append(resources.getString("qkey.msg.msg253"));
                    sbuf.append("\n\n");
                    return tf;
                }
                catch (Exception ex) {
                    mp.cleanupWorkDir(workdir);
                    ex.printStackTrace();
                }
            } else if (sel_message instanceof Message) {
                MessagePersister mp = new MessagePersister(sel_message);
                mp.setMsgDialog(cmp);
                mp.setTextBuffer(sbuf);
                try {
                    workdir = mp.persistToFile();
                    String file_target_string = this.thisproperty.getReal_file_directory() + QBrowserUtil.eliminateDameMoji(sel_message.getJMSMessageID()) + "_Message.zip";
                    tf = new File(file_target_string);
                    mp.zipUp(workdir, tf);
                    sbuf.append(resources.getString("qkey.msg.msg253"));
                    sbuf.append("\n\n");
                    return tf;
                }
                catch (Exception ex) {
                    mp.cleanupWorkDir(workdir);
                    ex.printStackTrace();
                }
            }
            return tf;
        }

        public File localMessageToFile(Session session, LocalMessageContainer lmc, StringBuilder sbuf, JDialog cmp) throws Exception {
            File tf = null;
            File workdir = null;
            Message innermessage = lmc.getMessage();
            if (innermessage == null) {
                innermessage = lmc.getRealMessage(session);
            }
            if (innermessage instanceof TextMessage) {
                TextMessagePersister mp = new TextMessagePersister(lmc);
                mp.setTextBuffer(sbuf);
                mp.setMsgDialog(cmp);
                try {
                    workdir = mp.persistToFile();
                    String file_target_string = this.thisproperty.getReal_file_directory() + QBrowserUtil.eliminateDameMoji(lmc.getVmsgid()) + "_TextMessage.zip";
                    tf = new File(file_target_string);
                    mp.zipUp(workdir, tf);
                    sbuf.append(resources.getString("qkey.msg.msg253"));
                    sbuf.append("\n\n");
                    cmp.getRootPane().updateUI();
                    lmc.setReal_file_path(file_target_string);
                    return tf;
                }
                catch (Exception ex) {
                    mp.cleanupWorkDir(workdir);
                    ex.printStackTrace();
                }
            } else if (innermessage instanceof BytesMessage) {
                BytesMessagePersister mp = new BytesMessagePersister(lmc);
                mp.setTextBuffer(sbuf);
                mp.setMsgDialog(cmp);
                try {
                    workdir = mp.persistToFile();
                    String file_target_string = this.thisproperty.getReal_file_directory() + QBrowserUtil.eliminateDameMoji(lmc.getVmsgid()) + "_BytesMessage.zip";
                    tf = new File(file_target_string);
                    mp.zipUp(workdir, tf);
                    sbuf.append(resources.getString("qkey.msg.msg253"));
                    sbuf.append("\n\n");
                    cmp.getRootPane().updateUI();
                    lmc.setReal_file_path(file_target_string);
                    return tf;
                }
                catch (Exception ex) {
                    mp.cleanupWorkDir(workdir);
                    ex.printStackTrace();
                }
            } else if (innermessage instanceof MapMessage) {
                MapMessagePersister mp = new MapMessagePersister(lmc);
                mp.setTextBuffer(sbuf);
                mp.setMsgDialog(cmp);
                try {
                    workdir = mp.persistToFile();
                    String file_target_string = this.thisproperty.getReal_file_directory() + QBrowserUtil.eliminateDameMoji(lmc.getVmsgid()) + "_MapMessage.zip";
                    tf = new File(file_target_string);
                    mp.zipUp(workdir, tf);
                    sbuf.append(resources.getString("qkey.msg.msg253"));
                    sbuf.append("\n\n");
                    cmp.getRootPane().updateUI();
                    lmc.setReal_file_path(file_target_string);
                    return tf;
                }
                catch (Exception ex) {
                    mp.cleanupWorkDir(workdir);
                    ex.printStackTrace();
                }
            } else if (innermessage instanceof StreamMessage) {
                StreamMessagePersister mp = new StreamMessagePersister(lmc);
                mp.setTextBuffer(sbuf);
                mp.setMsgDialog(cmp);
                try {
                    workdir = mp.persistToFile();
                    String file_target_string = this.thisproperty.getReal_file_directory() + QBrowserUtil.eliminateDameMoji(lmc.getVmsgid()) + "_StreamMessage.zip";
                    tf = new File(file_target_string);
                    mp.zipUp(workdir, tf);
                    sbuf.append(resources.getString("qkey.msg.msg253"));
                    sbuf.append("\n\n");
                    cmp.getRootPane().updateUI();
                    lmc.setReal_file_path(file_target_string);
                    return tf;
                }
                catch (Exception ex) {
                    mp.cleanupWorkDir(workdir);
                    ex.printStackTrace();
                }
            } else if (innermessage instanceof ObjectMessage) {
                ObjectMessagePersister mp = new ObjectMessagePersister(lmc);
                mp.setTextBuffer(sbuf);
                mp.setMsgDialog(cmp);
                try {
                    workdir = mp.persistToFile();
                    String file_target_string = this.thisproperty.getReal_file_directory() + QBrowserUtil.eliminateDameMoji(lmc.getVmsgid()) + "_ObjectMessage.zip";
                    tf = new File(file_target_string);
                    mp.zipUp(workdir, tf);
                    sbuf.append(resources.getString("qkey.msg.msg253"));
                    sbuf.append("\n\n");
                    cmp.getRootPane().updateUI();
                    lmc.setReal_file_path(file_target_string);
                    return tf;
                }
                catch (Exception ex) {
                    mp.cleanupWorkDir(workdir);
                    ex.printStackTrace();
                }
            } else if (innermessage instanceof Message) {
                MessagePersister mp = new MessagePersister(lmc);
                mp.setMsgDialog(cmp);
                mp.setTextBuffer(sbuf);
                try {
                    workdir = mp.persistToFile();
                    String file_target_string = this.thisproperty.getReal_file_directory() + QBrowserUtil.eliminateDameMoji(lmc.getVmsgid()) + "_Message.zip";
                    tf = new File(file_target_string);
                    mp.zipUp(workdir, tf);
                    sbuf.append(resources.getString("qkey.msg.msg253"));
                    sbuf.append("\n\n");
                    cmp.getRootPane().updateUI();
                    lmc.setReal_file_path(file_target_string);
                    return tf;
                }
                catch (Exception ex) {
                    mp.cleanupWorkDir(workdir);
                    ex.printStackTrace();
                }
            }
            return tf;
        }
    }
}

