/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.localstore;

import com.qbrowser.QBrowserV2;
import com.qbrowser.container.MessageContainer;
import com.qbrowser.persist.BytesMessageReader;
import com.qbrowser.persist.MapMessageReader;
import com.qbrowser.persist.ObjectMessageReader;
import com.qbrowser.persist.PersistedMessageReader;
import com.qbrowser.persist.StreamMessageReader;
import com.qbrowser.persist.TextMessageReader;
import com.qbrowser.util.QBrowserUtil;
import java.io.File;
import javax.jms.Message;
import javax.jms.Session;

public class LocalMessageContainer
extends MessageContainer {
    private String real_file_path;

    public LocalMessageContainer() {
    }

    public LocalMessageContainer(File msgarchive) throws Exception {
        String filepath = msgarchive.getAbsolutePath();
        File wf = null;
        try {
            if (filepath.indexOf("_TextMessage") != -1) {
                TextMessageReader tmr = new TextMessageReader();
                wf = tmr.readPersistedMessageWithLazyLoad(new File(filepath));
                QBrowserUtil.populateHeadersOfLocalMessageContainer(tmr.recreateMessagefromReadDataWithLazyLoad(), this);
                PersistedMessageReader.clearDir(wf);
                wf = null;
            } else if (filepath.indexOf("_BytesMessage") != -1) {
                BytesMessageReader bmr = new BytesMessageReader();
                wf = bmr.readPersistedMessageWithLazyLoad(new File(filepath));
                QBrowserUtil.populateHeadersOfLocalMessageContainer(bmr.recreateMessagefromReadDataWithLazyLoad(), this);
                PersistedMessageReader.clearDir(wf);
                wf = null;
            } else if (filepath.indexOf("_MapMessage") != -1) {
                MapMessageReader mmr = new MapMessageReader();
                wf = mmr.readPersistedMessageWithLazyLoad(new File(filepath));
                QBrowserUtil.populateHeadersOfLocalMessageContainer(mmr.recreateMessagefromReadDataWithLazyLoad(), this);
                PersistedMessageReader.clearDir(wf);
                wf = null;
            } else if (filepath.indexOf("_StreamMessage") != -1) {
                StreamMessageReader smr = new StreamMessageReader();
                wf = smr.readPersistedMessageWithLazyLoad(new File(filepath));
                QBrowserUtil.populateHeadersOfLocalMessageContainer(smr.recreateMessagefromReadDataWithLazyLoad(), this);
                PersistedMessageReader.clearDir(wf);
                wf = null;
            } else if (filepath.indexOf("_ObjectMessage") != -1) {
                ObjectMessageReader omr = new ObjectMessageReader();
                wf = omr.readPersistedMessageWithLazyLoad(new File(filepath));
                QBrowserUtil.populateHeadersOfLocalMessageContainer(omr.recreateMessagefromReadDataWithLazyLoad(), this);
                PersistedMessageReader.clearDir(wf);
            } else if (filepath.indexOf("_Message") != -1) {
                PersistedMessageReader pmr = new PersistedMessageReader();
                wf = pmr.readPersistedMessageWithLazyLoad(new File(filepath));
                QBrowserUtil.populateHeadersOfLocalMessageContainer(pmr.recreateMessagefromReadDataWithLazyLoad(), this);
                PersistedMessageReader.clearDir(wf);
            }
        }
        catch (Exception reade) {
            PersistedMessageReader.clearDir(wf);
            throw new Exception(QBrowserV2.resources.getString("qkey.msg.msg337") + "\n\nFile=" + msgarchive.getAbsolutePath());
        }
    }

    public void deleteRealMessageFile() {
        File tf;
        if (this.real_file_path != null && (tf = new File(this.real_file_path)).exists()) {
            tf.delete();
        }
    }

    public void setMessage(Message message) {
        super.setMessage(message);
        if (message != null) {
            this.setMessage_type(QBrowserV2.messageType(message));
            try {
                this.setBody_size(QBrowserUtil.messageBodySizeOfLong(message));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setBody_size(0L);
            }
        }
    }

    public Message getRealMessage(Session session) throws Exception {
        Message imes = this.getMessage();
        if (imes != null) {
            return imes;
        }
        if (this.getMessage_type() == null) {
            this.setMessage_type(QBrowserUtil.getMessageTypeFromRealFilePath(this.real_file_path));
        }
        File wf = null;
        try {
            if (this.getMessage_type().equals("TextMessage")) {
                TextMessageReader tmr = new TextMessageReader();
                wf = tmr.readPersistedMessage(new File(this.real_file_path));
                LocalMessageContainer tmsg = tmr.recreateMessagefromReadData(session);
                PersistedMessageReader.clearDir(wf);
                wf = null;
                Message res = tmsg.getMessage();
                QBrowserUtil.populateHeadersOfLocalMessageContainer2(tmsg, this);
                return res;
            }
            if (this.getMessage_type().equals("BytesMessage")) {
                BytesMessageReader bmr = new BytesMessageReader();
                wf = bmr.readPersistedMessage(new File(this.real_file_path));
                LocalMessageContainer tmsg = bmr.recreateMessagefromReadData(session);
                PersistedMessageReader.clearDir(wf);
                wf = null;
                Message res = tmsg.getMessage();
                long bsize = this.getBody_size();
                QBrowserUtil.populateHeadersOfLocalMessageContainer2(tmsg, this);
                this.setBody_size(bsize);
                return res;
            }
            if (this.getMessage_type().equals("MapMessage")) {
                MapMessageReader mmr = new MapMessageReader();
                wf = mmr.readPersistedMessage(new File(this.real_file_path));
                LocalMessageContainer tmsg = mmr.recreateMessagefromReadData(session);
                PersistedMessageReader.clearDir(wf);
                wf = null;
                Message res = tmsg.getMessage();
                QBrowserUtil.populateHeadersOfLocalMessageContainer2(tmsg, this);
                return res;
            }
            if (this.getMessage_type().equals("StreamMessage")) {
                StreamMessageReader smr = new StreamMessageReader();
                wf = smr.readPersistedMessage(new File(this.real_file_path));
                LocalMessageContainer tmsg = smr.recreateMessagefromReadData(session);
                PersistedMessageReader.clearDir(wf);
                wf = null;
                Message res = tmsg.getMessage();
                QBrowserUtil.populateHeadersOfLocalMessageContainer2(tmsg, this);
                return res;
            }
            if (this.getMessage_type().equals("ObjectMessage")) {
                ObjectMessageReader omr = new ObjectMessageReader();
                wf = omr.readPersistedMessage(new File(this.real_file_path));
                LocalMessageContainer tmsg = omr.recreateMessagefromReadData(session);
                PersistedMessageReader.clearDir(wf);
                Message res = tmsg.getMessage();
                QBrowserUtil.populateHeadersOfLocalMessageContainer2(tmsg, this);
                return res;
            }
            if (this.getMessage_type().equals("Message")) {
                PersistedMessageReader pmr = new PersistedMessageReader();
                wf = pmr.readPersistedMessage(new File(this.real_file_path));
                LocalMessageContainer tmsg = pmr.recreateMessagefromReadData(session);
                PersistedMessageReader.clearDir(wf);
                Message res = tmsg.getMessage();
                QBrowserUtil.populateHeadersOfLocalMessageContainer2(tmsg, this);
                return res;
            }
        }
        catch (Exception ie) {
            PersistedMessageReader.clearDir(wf);
            throw ie;
        }
        return null;
    }

    public String getReal_file_path() {
        return this.real_file_path;
    }

    public void setReal_file_path(String real_file_path) {
        this.real_file_path = real_file_path;
    }
}

