/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.web.BrokerFacadeSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteJMXBrokerFacade
extends BrokerFacadeSupport {
    private static final transient Log LOG = LogFactory.getLog(RemoteJMXBrokerFacade.class);
    private String jmxUrl;
    private String jmxRole;
    private String jmxPassword;
    private String brokerName;
    private JMXConnector connector;

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public void setJmxUrl(String url) {
        this.jmxUrl = url;
    }

    public void setJmxRole(String role) {
        this.jmxRole = role;
    }

    public void setJmxPassword(String password) {
        this.jmxPassword = password;
    }

    public void shutdown() {
        this.closeConnection();
    }

    public BrokerViewMBean getBrokerAdmin() throws Exception {
        MBeanServerConnection connection = this.getConnection();
        Set brokers = this.findBrokers(connection);
        if (brokers.size() == 0) {
            throw new IOException("No broker could be found in the JMX.");
        }
        ObjectName name = (ObjectName)brokers.iterator().next();
        BrokerViewMBean mbean = MBeanServerInvocationHandler.newProxyInstance(connection, name, BrokerViewMBean.class, true);
        return mbean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MBeanServerConnection getConnection() throws IOException {
        JMXConnector connector = this.connector;
        if (this.isConnectionActive(connector)) {
            return connector.getMBeanServerConnection();
        }
        RemoteJMXBrokerFacade remoteJMXBrokerFacade = this;
        synchronized (remoteJMXBrokerFacade) {
            this.closeConnection();
            LOG.debug((Object)"Creating a new JMX-Connection to the broker");
            this.connector = this.createConnection();
            return this.connector.getMBeanServerConnection();
        }
    }

    protected boolean isConnectionActive(JMXConnector connector) {
        if (connector == null) {
            return false;
        }
        try {
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            int brokerCount = this.findBrokers(connection).size();
            return brokerCount > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected JMXConnector createConnection() {
        String[] urls = this.jmxUrl.split(",");
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        env.put("jmx.remote.credentials", new String[]{this.jmxRole, this.jmxPassword});
        if (urls == null || urls.length == 0) {
            urls = new String[]{this.jmxUrl};
        }
        Exception exception = null;
        for (int i = 0; i < urls.length; ++i) {
            try {
                JMXConnector connector = JMXConnectorFactory.connect(new JMXServiceURL(urls[i]), env);
                connector.connect();
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                Set brokers = this.findBrokers(connection);
                if (brokers.size() <= 0) continue;
                LOG.info((Object)("Connected via JMX to the broker at " + urls[i]));
                return connector;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (exception != null) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
        throw new IllegalStateException("No broker is found at any of the urls " + this.jmxUrl);
    }

    protected synchronized void closeConnection() {
        if (this.connector != null) {
            try {
                LOG.debug((Object)("Closing a connection to a broker (" + this.connector.getConnectionId() + ")"));
                this.connector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected Set findBrokers(MBeanServerConnection connection) throws IOException, MalformedObjectNameException {
        ObjectName name = this.brokerName == null ? new ObjectName("org.apache.activemq:Type=Broker,*") : new ObjectName("org.apache.activemq:BrokerName=" + this.brokerName + ",Type=Broker");
        Set<ObjectName> brokers = connection.queryNames(name, null);
        return brokers;
    }

    public void purgeQueue(ActiveMQDestination destination) throws Exception {
        QueueViewMBean queue = this.getQueue(destination.getPhysicalName());
        queue.purge();
    }

    public ManagementContext getManagementContext() {
        throw new IllegalStateException("not supported");
    }

    protected Collection getManagedObjects(ObjectName[] names, Class type) {
        MBeanServerConnection connection;
        try {
            connection = this.getConnection();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList answer = new ArrayList();
        if (connection != null) {
            for (int i = 0; i < names.length; ++i) {
                ObjectName name = names[i];
                Object value = MBeanServerInvocationHandler.newProxyInstance(connection, name, type, true);
                if (value == null) continue;
                answer.add(value);
            }
        }
        return answer;
    }
}

