/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.objstore.jndi;

import com.sun.messaging.jmq.admin.objstore.AuthenticationException;
import com.sun.messaging.jmq.admin.objstore.AuthenticationNotSupportedException;
import com.sun.messaging.jmq.admin.objstore.CommunicationException;
import com.sun.messaging.jmq.admin.objstore.GeneralNamingException;
import com.sun.messaging.jmq.admin.objstore.InitializationException;
import com.sun.messaging.jmq.admin.objstore.InvalidAttributesException;
import com.sun.messaging.jmq.admin.objstore.NameAlreadyExistsException;
import com.sun.messaging.jmq.admin.objstore.NameNotFoundException;
import com.sun.messaging.jmq.admin.objstore.NoPermissionException;
import com.sun.messaging.jmq.admin.objstore.NotContextException;
import com.sun.messaging.jmq.admin.objstore.ObjStore;
import com.sun.messaging.jmq.admin.objstore.ObjStoreAttrs;
import com.sun.messaging.jmq.admin.objstore.ObjStoreException;
import com.sun.messaging.jmq.admin.objstore.SchemaViolationException;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class JNDIStore
implements ObjStore {
    private ObjStoreAttrs attrs = null;
    private boolean open = false;
    private DirContext dirCtx;
    private AdminResources ar = Globals.getAdminResources();
    private static final String SUN_LDAP_IC = "com.sun.jndi.ldap.LdapCtxFactory";

    public JNDIStore(ObjStoreAttrs objStoreAttrs) {
        this.attrs = objStoreAttrs;
    }

    public void open() throws ObjStoreException {
        try {
            this.dirCtx = this.attrs != null ? new InitialDirContext(this.attrs) : new InitialDirContext();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        this.open = true;
    }

    public void close() throws ObjStoreException {
        try {
            this.dirCtx.close();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        this.open = false;
    }

    public void add(String string, Object object, boolean bl) throws ObjStoreException {
        Object object2;
        BasicAttributes basicAttributes = null;
        try {
            Hashtable<?, ?> hashtable = this.dirCtx.getEnvironment();
            object2 = null;
            if (hashtable.containsKey("java.naming.factory.initial") && SUN_LDAP_IC.equals(object2 = (String)hashtable.get("java.naming.factory.initial")) && string.startsWith("cn=")) {
                basicAttributes = new BasicAttributes();
                basicAttributes.put("cn", string.substring(3));
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        try {
            if (basicAttributes != null) {
                this.dirCtx.bind(string, object, basicAttributes);
            } else {
                this.dirCtx.bind(string, object);
            }
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            if (bl) {
                try {
                    if (basicAttributes != null) {
                        this.dirCtx.rebind(string, object, basicAttributes);
                    }
                    this.dirCtx.rebind(string, object);
                }
                catch (Exception exception) {
                    this.handleException(exception);
                }
            }
            object2 = new NameAlreadyExistsException(this.ar.getString("A4002"));
            ((ObjStoreException)object2).setLinkedException(nameAlreadyBoundException);
            throw object2;
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void add(String string, Object object, Attributes attributes, boolean bl) throws ObjStoreException {
        Object object2;
        try {
            Hashtable<?, ?> hashtable = this.dirCtx.getEnvironment();
            object2 = null;
            if (hashtable.containsKey("java.naming.factory.initial") && SUN_LDAP_IC.equals(object2 = (String)hashtable.get("java.naming.factory.initial")) && string.startsWith("cn=")) {
                attributes.put("cn", string.substring(3));
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        try {
            this.dirCtx.bind(string, object, attributes);
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            if (bl) {
                try {
                    this.dirCtx.rebind(string, object, attributes);
                }
                catch (Exception exception) {
                    this.handleException(exception);
                }
            }
            object2 = new NameAlreadyExistsException(this.ar.getString("A4002"));
            ((ObjStoreException)object2).setLinkedException(nameAlreadyBoundException);
            throw object2;
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void delete(String string) throws ObjStoreException {
        try {
            this.dirCtx.unbind(string);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public Object retrieve(String string) throws ObjStoreException {
        Object object = null;
        try {
            object = this.dirCtx.lookup(string);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        return object;
    }

    public Vector list() throws ObjStoreException {
        Vector<NameClassPair> vector = new Vector<NameClassPair>();
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = this.dirCtx.list("");
            while (namingEnumeration.hasMore()) {
                NameClassPair nameClassPair = namingEnumeration.next();
                vector.add(nameClassPair);
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        return vector;
    }

    public Vector list(int[] nArray) throws ObjStoreException {
        return null;
    }

    public boolean isOpen() {
        return this.open;
    }

    public String getID() {
        return this.attrs.getID();
    }

    public String getDescription() {
        return this.attrs.getDescription();
    }

    public void setObjStoreAttrs(ObjStoreAttrs objStoreAttrs) throws ObjStoreException {
        this.attrs = objStoreAttrs;
    }

    public ObjStoreAttrs getObjStoreAttrs() {
        return this.attrs;
    }

    private void handleException(Exception exception) throws ObjStoreException {
        if (exception instanceof javax.naming.AuthenticationException) {
            AuthenticationException authenticationException = new AuthenticationException(this.ar.getString("A4003"));
            authenticationException.setLinkedException(exception);
            throw authenticationException;
        }
        if (exception instanceof javax.naming.AuthenticationNotSupportedException) {
            AuthenticationNotSupportedException authenticationNotSupportedException = new AuthenticationNotSupportedException(this.ar.getString("A4004"));
            authenticationNotSupportedException.setLinkedException(exception);
            throw authenticationNotSupportedException;
        }
        if (exception instanceof javax.naming.NoPermissionException) {
            NoPermissionException noPermissionException = new NoPermissionException(this.ar.getString("A4005"));
            noPermissionException.setLinkedException(exception);
            throw noPermissionException;
        }
        if (exception instanceof javax.naming.CommunicationException) {
            CommunicationException communicationException = new CommunicationException(this.ar.getString("A4006"));
            communicationException.setLinkedException(exception);
            throw communicationException;
        }
        if (exception instanceof NoInitialContextException) {
            InitializationException initializationException = new InitializationException(this.ar.getString("A4007"));
            initializationException.setLinkedException(exception);
            throw initializationException;
        }
        if (exception instanceof javax.naming.directory.SchemaViolationException) {
            SchemaViolationException schemaViolationException = new SchemaViolationException(this.ar.getString("A4008"));
            schemaViolationException.setLinkedException(exception);
            throw schemaViolationException;
        }
        if (exception instanceof javax.naming.NameNotFoundException) {
            NameNotFoundException nameNotFoundException = new NameNotFoundException(this.ar.getString("A4009"));
            nameNotFoundException.setLinkedException(exception);
            throw nameNotFoundException;
        }
        if (exception instanceof NameAlreadyBoundException) {
            NameAlreadyExistsException nameAlreadyExistsException = new NameAlreadyExistsException(this.ar.getString("A4010"));
            nameAlreadyExistsException.setLinkedException(exception);
            throw nameAlreadyExistsException;
        }
        if (exception instanceof javax.naming.NotContextException) {
            NotContextException notContextException = new NotContextException(this.ar.getString("A4011"));
            notContextException.setLinkedException(exception);
            throw notContextException;
        }
        if (exception instanceof javax.naming.directory.InvalidAttributesException) {
            InvalidAttributesException invalidAttributesException = new InvalidAttributesException(this.ar.getString("A4012"));
            invalidAttributesException.setLinkedException(exception);
            throw invalidAttributesException;
        }
        if (exception instanceof NamingException) {
            GeneralNamingException generalNamingException = new GeneralNamingException(this.ar.getString("A4013"));
            generalNamingException.setLinkedException(exception);
            throw generalNamingException;
        }
        ObjStoreException objStoreException = new ObjStoreException();
        objStoreException.setLinkedException(exception);
        throw objStoreException;
    }

    public Vector checkAuthentication(ObjStoreAttrs objStoreAttrs) {
        Vector<String> vector = new Vector<String>();
        String string = null;
        if (objStoreAttrs.containsKey("java.naming.security.authentication") && "simple".equals(string = (String)objStoreAttrs.get("java.naming.security.authentication"))) {
            if (!objStoreAttrs.containsKey("java.naming.security.principal")) {
                vector.addElement("java.naming.security.principal");
            }
            if (!objStoreAttrs.containsKey("java.naming.security.credentials")) {
                vector.addElement("java.naming.security.credentials");
            }
        }
        return vector;
    }

    public void addObjStoreAttr(String string, String string2) {
        this.attrs.put(string, string2);
    }

    public void search() {
    }

    public void dump(Object object) {
    }

    private String getUserInput(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            Globals.stdOutPrint(string);
            return bufferedReader.readLine();
        }
        catch (IOException iOException) {
            Globals.stdErrPrintln(this.ar.getString("A1001"), this.ar.getKString("A3081"));
            return null;
        }
    }
}

