/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.property;

import com.qbrowser.container.MessageContainer;
import com.qbrowser.property.HeaderPropertyTable;
import com.qbrowser.property.Property;
import java.util.LinkedList;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.activemq.command.Message;

public class ActiveMQHeaderPropertyTable
extends HeaderPropertyTable {
    public ActiveMQHeaderPropertyTable() {
    }

    public ActiveMQHeaderPropertyTable(int row) {
        super(row);
    }

    public int load(MessageContainer mc) {
        if (mc == null) {
            return 0;
        }
        javax.jms.Message message = mc.getMessage();
        if (message == null) {
            return 0;
        }
        this.list = new LinkedList();
        try {
            int jgsq;
            Message acm;
            String jgroupid;
            int jpri;
            String jcorid;
            String jtype;
            long jexp = message.getJMSExpiration();
            if (jexp != 0L) {
                Property jexp_prop = new Property();
                jexp_prop.setKey("JMSExpiration");
                jexp_prop.setProperty_type("Long");
                jexp_prop.setProperty_value(jexp);
                this.list.add(jexp_prop);
            }
            Destination d = message.getJMSReplyTo();
            String s = null;
            if (d != null) {
                s = d instanceof Queue ? "queue://" + ((Queue)d).getQueueName() : "topic://" + ((Topic)d).getTopicName();
            }
            if (s != null) {
                Property jrepto = new Property();
                jrepto.setKey("JMSReplyTo");
                jrepto.setProperty_type("String");
                jrepto.setProperty_value(s);
                this.list.add(jrepto);
            }
            if ((jtype = message.getJMSType()) != null && jtype.length() > 0) {
                Property jtypep = new Property();
                jtypep.setKey("JMSType");
                jtypep.setProperty_type("String");
                jtypep.setProperty_value(jtype);
                this.list.add(jtypep);
            }
            if ((jcorid = message.getJMSCorrelationID()) != null && jcorid.length() > 0) {
                Property jcoridp = new Property();
                jcoridp.setKey("JMSCorrelationID");
                jcoridp.setProperty_type("String");
                jcoridp.setProperty_value(jcorid);
                this.list.add(jcoridp);
            }
            if ((jpri = message.getJMSPriority()) != 4) {
                Property jprip = new Property();
                jprip.setKey("JMSPriority");
                jprip.setProperty_type("Int");
                jprip.setProperty_value(jpri);
                this.list.add(jprip);
            }
            if ((jgroupid = (acm = (Message)message).getGroupID()) != null && jgroupid.length() != 0) {
                Property jgroupidp = new Property();
                jgroupidp.setKey("Message Group");
                jgroupidp.setProperty_type("String");
                jgroupidp.setProperty_value(jgroupid);
                this.list.add(jgroupidp);
            }
            if ((jgsq = acm.getGroupSequence()) != 0) {
                Property jgsqp = new Property();
                jgsqp.setKey("Message Group Sequence Number");
                jgsqp.setProperty_type("Int");
                jgsqp.setProperty_value(jgsq);
                this.list.add(jgsqp);
            }
            this.fireTableDataChanged();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return this.list.size();
    }

    public int loadAllProperties(MessageContainer mc) {
        if (mc == null) {
            return 0;
        }
        this.list = new LinkedList();
        try {
            javax.jms.Message message = mc.getMessage();
            String msgid = message.getJMSMessageID();
            Property msgidp = new Property();
            msgidp.setKey("JMSMessageID");
            msgidp.setProperty_type("String");
            msgidp.setProperty_value(msgid);
            this.list.add(msgidp);
            Destination d1 = mc.getVdest();
            String s1 = null;
            s1 = d1 != null ? (d1 instanceof Queue ? "queue://" + ((Queue)d1).getQueueName() : "topic://" + ((Topic)d1).getTopicName()) : "";
            Property jdestp = new Property();
            jdestp.setKey("JMSDestination");
            jdestp.setProperty_type("String");
            jdestp.setProperty_value(s1);
            this.list.add(jdestp);
            Destination d = mc.getVreplyto();
            String s = null;
            s = d != null ? (d instanceof Queue ? "queue://" + ((Queue)d).getQueueName() : "topic://" + ((Topic)d).getTopicName()) : "";
            Property jrepto = new Property();
            jrepto.setKey("JMSReplyTo");
            jrepto.setProperty_type("String");
            jrepto.setProperty_value(s);
            this.list.add(jrepto);
            String jcorid = message.getJMSCorrelationID();
            Property jcoridp = new Property();
            jcoridp.setKey("JMSCorrelationID");
            jcoridp.setProperty_type("String");
            jcoridp.setProperty_value(jcorid);
            this.list.add(jcoridp);
            int delivermode = message.getJMSDeliveryMode();
            Property delivermodep = new Property();
            delivermodep.setKey("JMSDeliverMode");
            delivermodep.setProperty_type("Int");
            delivermodep.setProperty_value(delivermode);
            this.list.add(delivermodep);
            int jpri = message.getJMSPriority();
            Property jprip = new Property();
            jprip.setKey("JMSPriority");
            jprip.setProperty_type("Int");
            jprip.setProperty_value(jpri);
            this.list.add(jprip);
            long jexp = message.getJMSExpiration();
            Property jexp_prop = new Property();
            jexp_prop.setKey("JMSExpiration");
            jexp_prop.setProperty_type("Long");
            jexp_prop.setProperty_value(jexp);
            this.list.add(jexp_prop);
            String jtype = message.getJMSType();
            Property jtypep = new Property();
            jtypep.setKey("JMSType");
            jtypep.setProperty_type("String");
            jtypep.setProperty_value(jtype);
            this.list.add(jtypep);
            boolean redelivered = message.getJMSRedelivered();
            Property redvd = new Property();
            redvd.setKey("JMSRedelivered");
            redvd.setProperty_type("Boolean");
            redvd.setProperty_value(redelivered);
            this.list.add(redvd);
            long jtimestamp = message.getJMSTimestamp();
            Property jtimestampp = new Property();
            jtimestampp.setKey("JMSTimestamp");
            jtimestampp.setProperty_type("Long");
            jtimestampp.setProperty_value(jtimestamp);
            this.list.add(jtimestampp);
            Message acm = (Message)message;
            String jgroupid = acm.getGroupID();
            Property jgroupidp = new Property();
            jgroupidp.setKey("Message Group");
            jgroupidp.setProperty_type("String");
            jgroupidp.setProperty_value(jgroupid);
            this.list.add(jgroupidp);
            int jgsq = acm.getGroupSequence();
            Property jgsqp = new Property();
            jgsqp.setKey("Message Group Sequence Number");
            jgsqp.setProperty_type("Int");
            jgsqp.setProperty_value(jgsq);
            this.list.add(jgsqp);
            this.fireTableDataChanged();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return this.list.size();
    }
}

