#include <windows.h>
#include <process.h>
#include <errno.h>
#include <stdio.h>

void displayErrorMessage(char* msg) {
    MessageBox(NULL, msg, "G[", MB_OK);
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow )
{
  int iRet;
  char path[MAX_PATH];
  char szDrive[_MAX_DRIVE], szDir[_MAX_DIR], szFileName[_MAX_FNAME], szExt[_MAX_EXT];
  char basePath[MAX_PATH];
  char classPath[MAX_PATH];
  char libPath[MAX_PATH];
  char tempPath[MAX_PATH];
  char tmpPath[MAX_PATH];
  char *args[5];
  char tempF[MAX_PATH];
  char iniFilePath[MAX_PATH];
  FILE *fp;
  char mainClass[_MAX_FNAME];
  char javaOptions[1024];
  char message[256];
  int i;

  iRet = GetModuleFileName(NULL, path, sizeof(path));
  if (iRet==0) {
    displayErrorMessage("CXg[ꏊ̌oɎs܂D");
    return 1;
  }

  _splitpath_s( path, szDrive, _MAX_DRIVE, szDir, _MAX_DIR, szFileName, _MAX_FNAME, szExt, _MAX_EXT );

  strcpy_s(basePath, szDrive);
  strcat_s(basePath, szDir);

  strcpy_s(iniFilePath, basePath);
  strcat_s(iniFilePath, "JavaLaunch.ini");
  iRet = fopen_s(&fp,iniFilePath,"r");
  if (iRet) {
    displayErrorMessage("ݒt@C̓ǂݍ݂Ɏs܂D");
    return 1;
  }
  fgets(mainClass,_MAX_FNAME,fp);
  for (i=0;i<_MAX_FNAME;i++) {
    if (mainClass[i]=='\n') {
      mainClass[i] = '\0';
      break;
    }
  }
  fgets(javaOptions,512,fp);
  fclose(fp);
  for (i=0;i<512;i++) {
    if (javaOptions[i]=='\n') {
      javaOptions[i] = '\0';
      break;
    }
  }

  strcpy_s(classPath, "CLASSPATH=.;");
  strcat_s(classPath, basePath);
  strcat_s(classPath, "res\\*;");
  strcat_s(classPath, basePath);
  strcat_s(classPath, "lib\\*;");

  strcpy_s(libPath, "PATH=.;");
  strcat_s(libPath, basePath);
  strcat_s(libPath, "bin;");
  strcat_s(libPath, basePath);
  strcat_s(libPath, "Java\\jre\bin;");
  strcat_s(libPath, basePath);
  strcat_s(libPath, "Java\\jdk\bin;");

  strcpy_s(tempPath, "TEMP=");
  GetEnvironmentVariable("TEMP",tempF,MAX_PATH);
  strcat_s(tempPath, tempF);
  strcpy_s(tmpPath, "TMP=");
  strcat_s(tmpPath, tempF);

  char *my_env[] = { classPath, libPath, tempPath, tmpPath, NULL };

  if ((!lpCmdLine)||(!strlen(lpCmdLine))) {
    args[0] = "javaw.exe";
    args[1] = javaOptions;
    args[2] = mainClass;
    args[3] = NULL;
  } else {
    args[0] = "javaw.exe";
    args[1] = javaOptions;
    args[2] = mainClass;
    args[3] = lpCmdLine;
    args[4] = NULL;
  }

  iRet = _spawnvpe(_P_WAIT, "javaw.exe", args, my_env);
  // bZ[W{bNXɕ\܂B
  if(iRet == -1) {
    if(errno == ENOENT) {
      displayErrorMessage("ŐVJavaCXg[ăpXʂĉ");
    } else if(errno == ENOMEM) {
      displayErrorMessage("sł");
    } else if(errno == E2BIG) {
      displayErrorMessage("Xg 1024 oCg𒴂Ă܂");
    } else if (errno == EINVAL) {
      displayErrorMessage("_spawnvpeĂяoŕsȈIH");
    } else {
      displayErrorMessage("\ȂG[܂");
    }
    return 1;
  } else if (iRet != 0) {
    sprintf_s(message,256,"javawIXe[^X%dŏI܂D",iRet);
    displayErrorMessage(message);
    return 1;
  }
  //displayErrorMessage("G[ȂƂɂȂĂH");//OŎ񂾂Ƃɂ̂DDD
  return 0;
}
