/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.sablecc.sablecc.AcceptStates;
import org.sablecc.sablecc.ConstructNFA;
import org.sablecc.sablecc.DFA;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.NFA;
import org.sablecc.sablecc.ResolveIds;
import org.sablecc.sablecc.Transitions;
import org.sablecc.sablecc.analysis.AnalysisAdapter;
import org.sablecc.sablecc.node.Node;
import org.sablecc.sablecc.node.Start;

public class GenLexer
extends AnalysisAdapter {
    private MacroExpander macros;
    private ResolveIds ids;
    private File pkgDir;
    private String pkgName;
    private AcceptStates[] acceptStatesArray;
    private Transitions transitions;

    public void caseStart(Start start) {
        int n = Math.max(1, this.ids.stateList.size());
        this.acceptStatesArray = new AcceptStates[n];
        String[] stringArray = new String[n];
        if (this.ids.stateList.size() == 0) {
            stringArray[0] = "INITIAL";
        } else {
            Iterator iterator = this.ids.stateList.iterator();
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = (String)iterator.next();
                ++n2;
            }
        }
        int n3 = 0;
        while (n3 < n) {
            System.out.println(" State: " + stringArray[n3]);
            System.out.println(" - Constructing NFA.");
            ConstructNFA constructNFA = new ConstructNFA(this.ids, stringArray[n3]);
            start.apply(constructNFA);
            System.out.println();
            NFA nFA = (NFA)constructNFA.getOut(start);
            constructNFA = null;
            System.out.println(" - Constructing DFA.");
            DFA dFA = new DFA(nFA);
            System.out.println();
            System.out.println(" - resolving ACCEPT states.");
            this.acceptStatesArray[n3] = new AcceptStates(dFA, this.ids, stringArray[n3]);
            start.apply(this.acceptStatesArray[n3]);
            ++n3;
        }
        this.transitions = new Transitions();
        start.apply(this.transitions);
        this.createLexerException();
        this.createLexer();
    }

    private final void createLexerException() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "LexerException.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "LexerException.java").getAbsolutePath());
        }
        try {
            this.macros.apply(bufferedWriter, "LexerException", new String[]{this.pkgName});
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "LexerException.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final void createLexer() {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.pkgDir, "Lexer.java")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "Lexer.java").getAbsolutePath());
        }
        try {
            Enumeration enumeration;
            Object object;
            Object object2;
            boolean bl;
            Cloneable cloneable;
            String string;
            String string2 = "INITIAL";
            if (this.ids.stateList.size() > 0) {
                string2 = (String)this.ids.stateList.getFirst();
            }
            this.macros.apply(bufferedWriter, "LexerHeader", new String[]{this.pkgName, this.ids.pkgName.equals("") ? "node" : this.ids.pkgName + ".node", string2});
            Object object3 = this.ids.tokenList.listIterator();
            while (object3.hasNext()) {
                string = (String)object3.next();
                cloneable = (Node)this.ids.tokens.get(string);
                bl = (Boolean)this.ids.fixedTokens.get(cloneable);
                if (bl) {
                    this.macros.apply(bufferedWriter, "LexerFixedToken", new String[]{"" + object3.previousIndex(), string});
                } else {
                    this.macros.apply(bufferedWriter, "LexerVariableToken", new String[]{"" + object3.previousIndex(), string});
                }
                object2 = (Map)this.transitions.tokenStates.get(cloneable);
                if (object2.size() > 0) {
                    this.macros.apply(bufferedWriter, "TokenSwitchHeader", null);
                    object = object2.entrySet().iterator();
                    while (object.hasNext()) {
                        enumeration = object.next();
                        this.macros.apply(bufferedWriter, "TokenCase", new String[]{"" + this.ids.stateList.indexOf((String)enumeration.getKey()), (String)enumeration.getValue()});
                    }
                    this.macros.apply(bufferedWriter, "TokenSwitchTail", null);
                }
                this.macros.apply(bufferedWriter, "LexerTokenTail", null);
            }
            this.macros.apply(bufferedWriter, "LexerBody1");
            object3 = this.ids.tokenList.listIterator();
            while (object3.hasNext()) {
                string = (String)object3.next();
                cloneable = (Node)this.ids.tokens.get(string);
                bl = (Boolean)this.ids.fixedTokens.get(cloneable);
                if (bl) {
                    this.macros.apply(bufferedWriter, "LexerNewFixedToken", new String[]{"" + object3.previousIndex(), string});
                    continue;
                }
                this.macros.apply(bufferedWriter, "LexerNewVariableToken", new String[]{"" + object3.previousIndex(), string});
            }
            this.macros.apply(bufferedWriter, "LexerBody2");
            object3 = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(this.pkgDir, "lexer.dat"))));
            ((DataOutputStream)object3).writeInt(this.acceptStatesArray.length);
            int n = 0;
            while (n < this.acceptStatesArray.length) {
                cloneable = this.acceptStatesArray[n].dfa;
                bufferedWriter.write("        { // " + this.acceptStatesArray[n].stateName + System.getProperty("line.separator"));
                Vector<Object> vector = new Vector<Object>();
                int n2 = 0;
                while (n2 < ((DFA)((Object)cloneable)).states.size()) {
                    object = new Vector();
                    enumeration = (DFA.State)((DFA)((Object)cloneable)).states.elementAt(n2);
                    bufferedWriter.write("            {");
                    int n3 = 0;
                    while (n3 < ((DFA.State)((Object)enumeration)).transitions.size()) {
                        DFA.Transition transition = (DFA.Transition)((DFA.State)((Object)enumeration)).transitions.elementAt(n3);
                        bufferedWriter.write("{" + transition.interval().start + ", " + transition.interval().end + ", " + transition.destination + "}, ");
                        ((Vector)object).addElement(new int[]{transition.interval().start, transition.interval().end, transition.destination});
                        ++n3;
                    }
                    bufferedWriter.write("}," + System.getProperty("line.separator"));
                    vector.addElement(object);
                    ++n2;
                }
                bufferedWriter.write("        }" + System.getProperty("line.separator"));
                ((DataOutputStream)object3).writeInt(vector.size());
                object2 = vector.elements();
                while (object2.hasMoreElements()) {
                    object = (Vector)object2.nextElement();
                    ((DataOutputStream)object3).writeInt(((Vector)object).size());
                    enumeration = ((Vector)object).elements();
                    while (enumeration.hasMoreElements()) {
                        int[] nArray = (int[])enumeration.nextElement();
                        int n4 = 0;
                        while (n4 < 3) {
                            ((DataOutputStream)object3).writeInt(nArray[n4]);
                            ++n4;
                        }
                    }
                }
                ++n;
            }
            this.macros.apply(bufferedWriter, "LexerAcceptHeader");
            n = this.acceptStatesArray.length;
            cloneable = new Vector<Object>();
            int n5 = 0;
            while (n5 < n) {
                object2 = this.acceptStatesArray[n5].dfa;
                object = new Vector();
                bufferedWriter.write("        // " + this.acceptStatesArray[n5].stateName + System.getProperty("line.separator"));
                bufferedWriter.write("        {");
                int n6 = 0;
                while (n6 < ((DFA)object2).states.size()) {
                    DFA.State state = (DFA.State)((DFA)object2).states.elementAt(n6);
                    bufferedWriter.write(state.accept + ", ");
                    ((Vector)object).addElement(new Integer(state.accept));
                    ++n6;
                }
                bufferedWriter.write("}," + System.getProperty("line.separator"));
                cloneable.addElement(object);
                ++n5;
            }
            ((DataOutputStream)object3).writeInt(cloneable.size());
            Object object4 = cloneable.elements();
            while (object4.hasMoreElements()) {
                object2 = (Vector)object4.nextElement();
                ((DataOutputStream)object3).writeInt(((Vector)object2).size());
                object = ((Vector)object2).elements();
                while (object.hasMoreElements()) {
                    Integer n7 = (Integer)object.nextElement();
                    ((DataOutputStream)object3).writeInt(n7);
                }
            }
            ((FilterOutputStream)object3).close();
            bufferedWriter.write(System.getProperty("line.separator"));
            this.macros.apply(bufferedWriter, "LexerAcceptTail");
            this.macros.apply(bufferedWriter, "LexerStateHeader");
            if (this.ids.stateList.size() > 0) {
                object4 = this.ids.stateList.listIterator();
                while (object4.hasNext()) {
                    object2 = (String)object4.next();
                    this.macros.apply(bufferedWriter, "LexerStateBody", new String[]{object2, "" + object4.previousIndex()});
                }
            } else {
                this.macros.apply(bufferedWriter, "LexerStateBody", new String[]{"INITIAL", "0"});
            }
            this.macros.apply(bufferedWriter, "LexerStateTail");
            this.macros.apply(bufferedWriter, "LexerTail");
        }
        catch (IOException iOException) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Lexer.java").getAbsolutePath());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public GenLexer(ResolveIds resolveIds) {
        this.ids = resolveIds;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("lexer.txt")));
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to open lexer.txt.");
        }
        this.pkgDir = new File(resolveIds.pkgDir, "lexer");
        String string = this.pkgName = resolveIds.pkgName.equals("") ? "lexer" : resolveIds.pkgName + ".lexer";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }
}

